/*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */
jQuery.Class("CTWhatsAppExt_CTMaxPhoneNumberDigit_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTWhatsAppExt_CTMaxPhoneNumberDigit_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTWhatsAppExt_CTMaxPhoneNumberDigit_Js.editInstance = instance;
            return instance;
        }
        return CTWhatsAppExt_CTMaxPhoneNumberDigit_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    
    registerSaveSettings:function() {
        jQuery('#saveMaxNumberDigitSettings').on('click',function(){
            maxNumberDigit = jQuery('input[name="maxNumberDigit"]').val();
            var regex = /^[0-9]+$/;
            var numberRegex = /^\d{1,2}$/;
            
            var flag = 0;
            if(maxNumberDigit == ''){
                var params = {
                    title : app.vtranslate('MSG_ENTER_MAX_NUMBER_DIGIT'),
                    text: app.vtranslate('MSG_ENTER_MAX_NUMBER_DIGIT'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
                flag = 1;
            }else if (!maxNumberDigit.match(regex)){
                var params = {
                    title : app.vtranslate('MSG_ENTER_ONLY_NUMERIC_VALUE'),
                    text: app.vtranslate('MSG_ENTER_ONLY_NUMERIC_VALUE'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
                flag = 1;
            }else if(numberRegex.test(maxNumberDigit)){
                var number = parseInt(maxNumberDigit);
                
                //if (number >= 8 && number <= 15) {
                if (number <= 7 || number > 15) {
                    var params = {
                        title : app.vtranslate('MSG_NUMBER_VALUE_LIMIT_VALIDATION'),
                        text: app.vtranslate('MSG_NUMBER_VALUE_LIMIT_VALIDATION'),
                        animation: 'show',
                        type: 'error'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                    flag = 1;
                }//end of else
            }//end of else if

            if(flag == 0){
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });

                var params = {};
                params['module'] = app.getModuleName();
                params['parent'] = app.getParentModuleName();
                params['action'] = 'SaveMaxNumberDigit';
                params['maxNumberDigit'] = maxNumberDigit;
                
                AppConnector.request(params).then(function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var message = data.result['message'];
                    var params = {
                        title : app.vtranslate(message),
                        text: message,
                        animation: 'show',
                        type: 'info'
                    };
                    Vtiger_Helper_Js.showMessage(params);
                    window.location.href = 'index.php?module=CTWhatsAppExt&parent=Settings&view=Dashboard';
                });
            }//end of if
        });

        jQuery('#removeMaxNumberDigit').on('click',function(){
            var params = {};
            params['module'] = app.getModuleName();
            params['parent'] = app.getParentModuleName();
            params['action'] = 'SaveMaxNumberDigit';
            params['maxNumberDigit'] = "";
            
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });

            AppConnector.request(params).then(function(data) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                var message = data.result['message'];
                var params = {
                    title : app.vtranslate(message),
                    text: message,
                    animation: 'show',
                    type: 'info'
                };
                Vtiger_Helper_Js.showMessage(params);
                location.reload();
            });
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSaveSettings(); 
    }
});

jQuery(document).ready(function () {
    var instance = new CTWhatsAppExt_CTMaxPhoneNumberDigit_Js();
    instance.registerEvents();
    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();
});