 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTWhatsAppExt_CountryCode_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTWhatsAppExt_CountryCode_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTWhatsAppExt_CountryCode_Js.editInstance = instance;
            return instance;
        }
        return CTWhatsAppExt_CountryCode_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    

    registerSaveSettings:function() {
        jQuery('#save_countrycode_settings').on('click',function(){
            country_code = jQuery('input[name="country_code"]').val();
            var regex=/^[0-9]+$/;
            
            if(country_code == ''){

                var params = {
                    title : app.vtranslate('Please Enter Country Code'),
                    text: app.vtranslate('Please Enter Country Code'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else if (!country_code.match(regex)){
                var params = {
                    title : app.vtranslate('Please enter Numeric value only'),
                    text: app.vtranslate('Please enter Numeric value only'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else{
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });

                var params = {};
                params['module'] = app.getModuleName();
                params['parent'] = app.getParentModuleName();
                params['action'] = 'SaveCountryCode';
                params['country_code'] = country_code;
                
                AppConnector.request(params).then(function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        //var msg = app.vtranslate('Country Code saved successfully');
                        var msg=data.result['msg'];
                        var params = {
                            title : app.vtranslate(msg),
                            text: msg,
                            animation: 'show',
                            type: 'info'
                        };
                        Vtiger_Helper_Js.showMessage(params);
                        window.location.href = 'index.php?module=CTWhatsAppExt&parent=Settings&view=Dashboard';
                });
            }
         
            
        });

        jQuery('#remove_countrycode').on('click',function(){
            var params = {};
            params['module'] = app.getModuleName();
            params['parent'] = app.getParentModuleName();
            params['action'] = 'SaveCountryCode';
            params['country_code'] = "";
            
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            AppConnector.request(params).then(function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    //var msg = app.vtranslate('Country Code saved successfully');
                    var msg=data.result['msg'];
                    var params = {
                        title : app.vtranslate(msg),
                        text: msg,
                        animation: 'show',
                        type: 'info'
                    };
                    Vtiger_Helper_Js.showMessage(params);
                    location.reload();
                    /*window.location.href = 'index.php?module=CTWhatsAppExt&parent=Settings&view=Dashboard';*/
            });
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSaveSettings(); 
    }
});


jQuery(document).ready(function () {
    var instance = new CTWhatsAppExt_CountryCode_Js();
    instance.registerEvents();
    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();
});
