 /*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */
jQuery.Class("CTWhatsAppExt_License_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTWhatsAppExt_License_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTWhatsAppExt_License_Js.editInstance = instance;
            return instance;
        }
        return CTWhatsAppExt_License_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    

    registerSaveSettings:function() {
        jQuery('#save_license_settings').on('click',function(){
            License_Key = jQuery('input[name="License_Key"]').val();
            if(License_Key == ''){

                var params = {
                    title : app.vtranslate('Please Enter License Key'),
                    text: app.vtranslate('Please Enter License Key'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else{
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });

                var params = {};
                params['module'] = app.getModuleName();
                params['parent'] = app.getParentModuleName();
                params['action'] = 'SaveLicense';
                params['license_key'] = License_Key;
                
                AppConnector.request(params).then(function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        var msg=data.result['msg'];
                        var code =data.result['code'];
                        if(code === 100 || code === 101){
                            var params = {
                                title : app.vtranslate(msg),
                                text: msg,
                                animation: 'show',
                                type: 'error'
                            };
                            Vtiger_Helper_Js.showPnotify(params);   
                        }else if(code === 103){
                            another_domain = data.result['domain'];
                            license_key = License_Key;

                            var params = {};
                            params['module'] = app.getModuleName();
                            params['parent'] = app.getParentModuleName();
                            params['action'] = 'Deactivate';
                            params['domain'] = another_domain;
                            params['license_key'] = license_key;
                            var message1 = app.vtranslate('Your License key is already registered with')+'"'+another_domain+'" ,'+app.vtranslate('Are you Sure Want to Deactivate from there and Activate to current Instance ?');
                            app.helper.showConfirmationBox({'message' : message1}).then(function(data) {
                                var progressIndicatorElement2 = jQuery.progressIndicator({
                                    'position' : 'html',
                                    'blockInfo' : {
                                        'enabled' : true
                                    }
                                });
                                AppConnector.request(params).then(function(data1) {
                                        var params2 = {};
                                        params2['module'] = app.getModuleName();
                                        params2['parent'] = app.getParentModuleName();
                                        params2['action'] = 'SaveLicense';
                                        params2['license_key'] = License_Key;
                                        AppConnector.request(params2).then(function(data2) {
                                            progressIndicatorElement2.progressIndicator({'mode' : 'hide'});
                                            var msg2=data2.result['msg'];
                                            var code2 =data2.result['code'];
                                            if(code2 === 100 || code2 === 101 || code2 === 103){
                                                var pparams = {
                                                    title : app.vtranslate('Something went wrong'),
                                                    text: app.vtranslate('Something went wrong'),
                                                    animation: 'show',
                                                    type: 'error'
                                                };
                                                Vtiger_Helper_Js.showPnotify(pparams);
                                            }else{
                                                var params = {
                                                    title : app.vtranslate(msg2),
                                                    text: msg2,
                                                    animation: 'show',
                                                    type: 'info'
                                                };
                                                Vtiger_Helper_Js.showMessage(params);
                                                window.location.href = 'index.php?module=CTWhatsAppExt&parent=Settings&view=Dashboard';
                                            }
                                        });   
                                });
                            }); 
                        }else{
                            var params = {
                                title : app.vtranslate(msg),
                                text: msg,
                                animation: 'show',
                                type: 'info'
                            };
                            Vtiger_Helper_Js.showMessage(params);
                            window.location.href = 'index.php?module=CTWhatsAppExt&parent=Settings&view=Dashboard';
                        }
                });
            }
         
            
        });

        jQuery('#deactivateLicense').live('click',function(){
            var params = {};
            params['module'] = app.getModuleName();
            params['parent'] = app.getParentModuleName();
            params['action'] = 'Deactivate';
            var message1 = app.vtranslate('MSG_CTWHATSAPPEXT_DEACTIVATE_POPUP');
            app.helper.showConfirmationBox({'message' : message1}).then(function(data) {
                app.request.post({data: params}).then(function(err, response) {
                    if(response){
                        var params = {
                            title : response.message,
                            text: response.message,
                            animation: 'show',
                            type: 'success'
                        };
                        Vtiger_Helper_Js.showPnotify(params);
                        location.reload();
                    }   
                });
            });
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSaveSettings(); 
    }
});


jQuery(document).ready(function () {
    var instance = new CTWhatsAppExt_License_Js();
    instance.registerEvents();
    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();
});
