<?php
 /*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */

include_once dirname(__FILE__) . '/CTWhatsAppExt.Config.php';

class CTWhatsAppExt {
	
	/**
	 * Detect if request is from IPhone
	 */
	static function isSafari() {
		if(isset($_SERVER['HTTP_USER_AGENT'])) {
			$ua = $_SERVER['HTTP_USER_AGENT'];
			if(preg_match("/safari/i", $ua)) return true;
		}
		return false;
	}
	
	static function templatePath($filename) {
		return vtlib_getModuleTemplate('CTWhatsAppExt',"generic/$filename");
	}
	
	static function config($key, $defvalue = false) {
		// Defined in the configuration file
		global $Module_Mobile_Configuration;
		if(isset($Module_Mobile_Configuration) && isset($Module_Mobile_Configuration[$key])) {
			return $Module_Mobile_Configuration[$key];
		}
		return $defvalue;
	}
	
	/**
	 * Alert management
	 */
	static function alert_lookup($handlerPath, $handlerClass) {
		global $adb;
		$check = $adb->pquery("SELECT id FROM vtiger_mobile_alerts WHERE handler_path=? and handler_class=?", array($handlerPath, $handlerClass));
		if ($adb->num_rows($check)) {
			return $adb->query_result($check, 0, 'id');
		}
		return false;
	}
	static function alert_register($handlerPath, $handlerClass) {
		global $adb;
		if (self::alert_lookup($handlerPath, $handlerClass) === false) {
			Vtiger_Utils::Log("Registered alert {$handlerClass} [$handlerPath]");
			$adb->pquery("INSERT INTO vtiger_mobile_alerts (handler_path, handler_class, deleted) VALUES(?,?,?)", array($handlerPath, $handlerClass, 0));
		}
	}
	static function alert_deregister($handlerPath, $handlerClass) {
		global $adb;
		Vtiger_Utils::Log("De-registered alert {$handlerClass} [$handlerPath]");
		$adb->pquery("DELETE FROM vtiger_mobile_alerts WHERE handler_path=? AND handler_class=?", array($handlerPath, $handlerClass));
	}
	static function alert_markdeleted($handlerPath, $handlerClass, $flag) {
		global $adb;
		$adb->pquery("UPDATE vtiger_mobile_alerts SET deleted=? WHERE handler_path=? AND handler_class=?", array($flag, $handlerPath, $handlerClass));
	}

	static function languageInit(){
        global $adb;
        $AllLanguage = Vtiger_Language::getAll();
        foreach ($AllLanguage as $language => $langname) {
             $checkLang = $adb->pquery("SELECT 1 FROM ctwhatsappext_language_keyword WHERE keyword_lang = ?",array($language));
        	 if($adb->num_rows($checkLang) == 0){
        	 	$adb->pquery("INSERT INTO `ctwhatsappext_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`) VALUES
				('app_title',	'Title',	'".$language."',	'Title'),
				('language',	'Language',	'".$language."',	'Language'),
				('welcome_message',	'Welcome',	'".$language."',	'Welcome'),
				('days_since_release',	'it\'s been {{number_of_days}} days since this video was released',	'".$language."',	'it\'s been {{number_of_days}} days since this video was released'),
				('PLEASE_SELECT_CONTACT_NUMBER',	'Please select contact Number.',	'".$language."',	'Please select contact Number.'),
				('all',	'All',	'".$language."',	'All'),
				('unRead',	'Unread',	'".$language."',	'Unread'),
				('mentions',	'Mentions',	'".$language."',	'Mentions'),
				('groups',	'Groups',	'".$language."',	'Groups'),
				('businesses',	'Businesses',	'".$language."',	'Businesses'),
				('WELCOME_MSG',	'Welcome to Whatsapp Chrome extension!',	'".$language."',	'Welcome to Whatsapp Chrome extension!'),
				('ADD',	'Add',	'".$language."',	'Add'),
				('CONTACT',	'Contact',	'".$language."',	'Contact'),
				('COPY_CONTACT_TO',	'Copy contact to',	'".$language."',	'Copy contact to'),
				('COPY_NAME_TO',	'Copy name to',	'".$language."',	'Copy name to'),
				('COPY_NUMBER_TO',	'Copy number to',	'".$language."',	'Copy number to'),
				('GROUP_DETAILS_SUB_TITLE',	'Save contacts directly to vTiger in a single click. This will ignore existing contacts already available in vTiger',	'".$language."',	'Save contacts directly to vTiger in a single click. This will ignore existing contacts already available in vTiger'),
				('GROUP_DETAILS_TITLE',	'Save Contacts to vTiger',	'".$language."',	'Save Contacts to vTiger'),
				('PROCESSED',	'Processed',	'".$language."',	'Processed'),
				('SAVE_RECORDS',	'Save records',	'".$language."',	'Save records'),
				('KEY_FIELDS',	'Key fields',	'".$language."',	'Key fields'),
				('CREATE',	'Create',	'".$language."',	'Create'),
				('NO_RECORD_FOUND_FOR_TAB',	'No records for this tab. Click on below Create button to Create new records.',	'".$language."',	'No records for this tab. Click on below Create button to Create new records.'),
				('NO_RECORDS_FOUND',	'No Records Found',	'".$language."',	'No Records Found'),
				('SOMETHING_WENT_WRONG',	'Something went wrong',	'".$language."',	'Something went wrong'),
				('SUBMIT',	'Submit',	'".$language."',	'Submit'),
				('ACCOUNTS',	'Accounts',	'".$language."',	'Accounts'),
				('ACTIVITIES',	'Activities',	'".$language."',	'Activities'),
				('ADD_COMMENTS',	'Add Comments',	'".$language."',	'Add Comments'),
				('BACK',	'Back',	'".$language."',	'Back'),
				('COMMENTS',	'Comments',	'".$language."',	'Comments'),
				('ENTER_COMMENTS',	'Enter comment',	'".$language."',	'Enter comment'),
				('LEADS',	'Leads',	'".$language."',	'Leads'),
				('NO_RECORD_FOUND',	'No Record Found',	'".$language."',	'No Record Found'),
				('ORGANIZATION',	'Organization',	'".$language."',	'Organization'),
				('POST',	'Post',	'".$language."',	'Post'),
				('TICKETS',	'Tickets',	'".$language."',	'Tickets'),
				('IS_REQUIRED',	'is required',	'".$language."',	'is required'),
				('LOGIN',	'Login',	'".$language."',	'Login'),
				('PASSWORD',	'Password',	'".$language."',	'Password'),
				('URL_STR',	'URL',	'".$language."',	'URL'),
				('USERNAME',	'Username',	'".$language."',	'Username'),
				('LOGOUT',	'Logout',	'".$language."',	'Logout'),
				('COMMENT_ADDED_SUCCESSFULLY',	'Comment added successfully',	'".$language."',	'Comment added successfully'),
				('RECORD_ADDED_SUCCESSFULLY',	'Record added successfully',	'".$language."',	'Record added successfully'),
				('REQUIRED',	'required',	'".$language."',	'required'),
				('VTIGER_URL_Link',	'vTigerURL/Link',	'".$language."',	'vTigerURL/Link'),
				('COLLAPSE',	'Collapse',	'".$language."',	'Collapse'),
				('NAME',	'Name',	'".$language."',	'Name'),
				('PHONE_NUMBER',	'Phone number',	'".$language."',	'Phone number'),
				('VENDOR',	'Vendor',	'".$language."',	'Vendor'),
				('NO_RECORD',	'No Record !',	'".$language."',	'No Record !'),
				('LEAD',	'Lead',	'".$language."',	'Lead'),
				('A',	'a',	'".$language."',	'a'),
				('AN',	'an',	'".$language."',	'an'),
				('NOT_APPLICABLE',	'N/A',	'".$language."',	'N/A'),
				('SUMMARY',	'Summary',	'".$language."',	'Summary'),
				('DETAILS',	'Details',	'".$language."',	'Details'),
				('RECENT_UPDATES',	'Recent Updates',	'".$language."',	'Recent Updates'),
				('OPPORTUNITIES',	'Opportunities',	'".$language."',	'Opportunities'),
				('EMAILS',	'Emails',	'".$language."',	'Emails'),
				('QUOTE',	'Quote',	'".$language."',	'Quote'),
				('PURCHASE_ORDER',	'Purchase Order',	'".$language."',	'Purchase Order'),
				('SALES_ORDER',	'Sales Order',	'".$language."',	'Sales Order'),
				('PRODUCTS',	'Products',	'".$language."',	'Products'),
				('DOCUMENTS',	'Documents',	'".$language."',	'Documents'),
				('CAMPAIGNS',	'Campaigns',	'".$language."',	'Campaigns'),
				('INVOICE',	'Invoice',	'".$language."',	'Invoice'),
				('SERVICES',	'Services',	'".$language."',	'Services'),
				('SERVICE_CONTRACTS',	'Service Contracts',	'".$language."',	'Service Contracts'),
				('PBX_MANAGER',	'PBX Manager',	'".$language."',	'PBX Manager'),
				('PROJECTS',	'Projects',	'".$language."',	'Projects'),
				('ASSETS',	'Assets',	'".$language."',	'Assets'),
				('VENDORS',	'Vendors',	'".$language."',	'Vendors'),
				('ORGANISATIONS',	'Organisations',	'".$language."',	'Organisations'),
				('INVALID_CRM_URL',	'Invalid CRM Url',	'".$language."',	'Invalid CRM Url'),
				('TASK',	'Task',	'".$language."',	'Task'),
				('EVENT',	'Event',	'".$language."',	'Event'),
				('TO',	'To',	'".$language."',	'To'),
				('RUN_CAMPAIGN',	'Run Campaign',	'".$language."',	'Run Campaign'),
				('SOMETHING_IS_MISSING',	'Something is missing',	'".$language."',	'Something is missing'),
				('ADD_FIELDS',	'Add Fields',	'".$language."',	'Add Fields'),
				('SELECT_MODULE',	'Select Module',	'".$language."',	'Select Module'),
				('PLEASE_SELECT_MODULE',	'Please select Module',	'".$language."',	'Please select Module'),
				('SELECT_OPPORTUNITY',	'Select Opportunity',	'".$language."',	'Select Opportunity'),
				('PLEASE_SELECT_OPPORTUNITY',	'Please select Opportunity',	'".$language."',	'Please select Opportunity'),
				('ADD_CONDITION',	'Add Condition',	'".$language."',	'Add Condition'),
				('LIKE',	'Like',	'".$language."',	'Like'),
				('IS_EQUAL',	'Is Equal',	'".$language."',	'Is Equal'),
				('BULK_CAMPAIGNING',	'Bulk Campaigning',	'".$language."',	'Bulk Campaigning'),
				('SELECT_CONTACT_TYPE',	'Select Contact Type',	'".$language."',	'Select Contact Type'),
				('ADD_MESSAGE',	'Add Message',	'".$language."',	'Add Message'),
				('SELECT_CONDITION',	'Select condition',	'".$language."',	'Select condition'),
				('SELECT_FIELD',	'Select field',	'".$language."',	'Select field'),
				('USERNAME_AND_PASSWORD_NOT_MATCH',	'Username and Password do not match',	'".$language."',	'Username and Password do not match'),
				('SOMETHING_WENT_WRONG',	'Something went wrong',	'".$language."',	'Something went wrong'),
				('PERMISSION_DENIED',	'Permission Denied',	'".$language."',	'Permission Denied'),
				('DONT_HAVE_PERMISSION_TO_ACCESS_PAGE',	'You do not have permission to access this page',	'".$language."',	'You do not have permission to access this page'),
				('FILTERS',	'Filters',	'".$language."',	'Filters'),
				('PREV',	'Prev',	'".$language."',	'Prev'),
				('NEXT',	'Next',	'".$language."',	'Next'),
				('RUN',	'Run',	'".$language."',	'Run'),
				('SEND_TO_ALL',	'Send to all',	'".$language."',	'Send to all'),
				('ADD_FILTER',	'Add Filter',	'".$language."',	'Add Filter'),
				('SELECT_VALUE',	'Select Value',	'".$language."',	'Select Value'),
				('MSG_ADDED_SUCCESSFULLY',	'Message added successfully',	'".$language."',	'Message added successfully'),
				('HOME',	'Home',	'".$language."',	'Home'),
				('DATE_OF_BIRTH',	'Date of birth',	'".$language."',	'Date of birth'),
				('SELECT_FILE',	'Select File',	'".$language."',	'Select File'),
				('SEND_PHOTOS_OR_DOCS',	'Send photo/document',	'".$language."',	'Send photo/document'),
				('TYPE_MESSAGE_HERE',	'Type message here...',	'".$language."',	'Type message here...'),
				('NO_OF_RECORDS',	'# of Records',	'".$language."',	'# of Records'),
				('SELECT_FIELD_AS_WHATSAPP_NO',	'Select Field as whatsapp number',	'".$language."',	'Select Field as whatsapp number'),
				('CHOOSE_FIELD_FOR_PERSONALIZED_MSG',	'Choose field for personalized messages',	'".$language."',	'Choose field for personalized messages'),
				('SEND_MSGS_WITH_PHOTOS_DOC',	'Send message(s) with photos/documents',	'".$language."',	'Send message(s) with photos/documents'),
				('PRIVACY_POLICY',	'Privacy policy',	'".$language."',	'Privacy policy'),
				('I_AGREE_TO_FOLLOW',	'I agree to follow',	'".$language."',	'I agree to follow'),
				('YOU_DONT_HAVE_ACCESS_TO_ANY_MODULES',	'You don\'t have access to any modules',	'".$language."',	'You don\'t have access to any modules'),
				('NO_CONTACT_FOUND_IN_THIS_MODULE',	'No contacts found in this module',	'".$language."',	'No contacts found in this module'),
				('PLEASE_SELECT_ANY_MODULE_TO_DISPLAY_CONTACT',	'Please Select any module to display contact list of specific module!',	'".$language."',	'Please Select any module to display contact list of specific module!'),
				('SAVE_CONTACTS_IN_CRM',	'Save your Contacts in CRM.',	'".$language."',	'Save your Contacts in CRM.'),
				('TOTAL_CONTACTS_TO_SYNC',	'Total # of contacts to sync',	'".$language."',	'Total # of contacts to sync'),
				('SELECT_MODULE_SAVE_CONTACTS_IN_CRM',	'Please select module for save contacts in CRM.',	'".$language."',	'Please select the module for saving contacts in CRM.'),
				('ALL_CONTACTS_SAVED_IN_CRM_MSG',	'Seems like contacts already saved in CRM, Please click on respected \r\n  contact to see it in Chrome extension panel.',	'".$language."',	'Seems like contacts already saved in CRM, Please click on respected contact to see it in Chrome extension panel.'),
				('SEND_TO_ALL_CONTACTS',	'Send To All Contacts',	'".$language."',	'Send To All Contacts'),
				('FILTERED_CONTACTS',	'Filtered Contacts',	'".$language."',	'Filtered Contacts'),
				('SAVE',	'Save',	'".$language."',	'Save'),
				('WAIT_UNTIL_CONTACT_SYNC',	'Please do not refresh screen until all contacts sync successfully...',	'".$language."',	'Please do not refresh screen until all contacts sync successfully...'),
				('WHATSAPP_CONTACTS_SYNCING',	'Whatsapp contacts syncing...',	'".$language."',	'Whatsapp contacts syncing...'),
				('MSG_CONFIRMATION',	'Are you sure want to send messages to selected record',	'".$language."',	'Are you sure want to send messages to selected record'),
				('NO',	'No',	'".$language."',	'No'),
				('YES',	'Yes',	'".$language."',	'Yes'),
				('SELECT_MASS_MSGING_TYPE',	'Please select mass-massaging type',	'".$language."',	'Please select mass-massaging type'),
				('MOBILE_NUMBER',	'Mobile Number',	'".$language."',	'Mobile Number'),
				('RECORD_SAVE_SUCCESSFULLY',	'Record save successfully',	'".$language."',	'Record save successfully'),
				('SELECT_MODULE_DISPLAY_CONTACT_LIST',	'Please Select any module to display contact list of specific module!',	'".$language."',	'Please Select any module to display contact list of specific module!'),
				('NO_DATA',	'No data',	'".$language."',	'No data'),
				('SCHEDULE_AN_EVENT',	'Schedule an event',	'".$language."',	'Schedule an event'),
				('REMIND_ME',	'Remind me',	'".$language."',	'Remind me'),
				('SYNC_CONTACTS_TO_CRM',	'Sync contacts to CRM',	'".$language."',	'Sync contacts to CRM'),
				('PLEASE_SELECT_MANDATORY_FIELDS',	'Please select mandatory fields.',	'".$language."',	'Please select mandatory fields.'),
				('SAVE_ALL_CONTACTS',	'Save All Contacts',	'".$language."',	'Save All Contacts'),
				('LIST',	'List',	'".$language."',	'List'),
				('CONTACTS',	'Contacts',	'".$language."',	'Contacts'),
				('GOTO_CRM_TIGER',	'Go to CRM Tiger',	'".$language."',	'Go to CRM Tiger'),
				('RESET',	'Reset',	'".$language."',	'Reset'),
				('CONTAINS',	'Contains',	'".$language."',	'Contains'),
				('STARTS_WITH',	'Starts With',	'".$language."',	'Starts With'),
				('ENDS_WITH',	'Ends With',	'".$language."',	'Ends With'),
				('INFORMATION',	'Information',	'".$language."',	'Information'),
				('RECORD_SYNCED',	'Record is already synced!',	'".$language."',	'Record is already synced!'),
				('GO_TO_USER_PROFILE',	'Go to user profile',	'".$language."',	'Go to user profile'),
				('GO_TO_RECORD_IN_CRM',	'Go To Record Detail in CRM',	'".$language."',	'Go To Record Detail in CRM'),
				('RECORDS_SAVED_SUCCESSFULLY',	'Records saved successfully',	'".$language."',	'Records saved successfully'),
				('SELECT_MODULE_FILTER',	'Select module filter',	'".$language."',	'Select module filter'),
				('URL_IS_WRONG',	'URL is wrong',	'".$language."',	'URL is wrong'),
				('PLEASE_VERIFY_VTIGER_URL',	'Please verify vTiger URL',	'".$language."',	'Please verify vTiger URL'),
				('CHECK_URL_WITH_HTTP_OR_HTTPS',	'Please check URL with http or https',	'".$language."',	'Please check URL with http or https'),
				('REMOVE_AFTER_URL_IF_YOU_ADDED',	'Remove /index.php after URL if you’ve added',	'".$language."',	'Remove /index.php after URL if you’ve added'),
				('URL_SHOULD_SAME_AS_YOUR_VTIGER_URL',	'URL should be same as your vTiger URL',	'".$language."',	'URL should be same as your vTiger URL'),
				('COPYRIGHT',	'Copyright',	'".$language."',	'Copyright'),
				('VERSION',	'Version',	'".$language."',	'Version'),
				('SEND',	'Send',	'".$language."',	'Send'),
				('ORGANIZATIONS',	'Organizations',	'".$language."',	'Organizations'),
				('MSG_SENT_SUCCESSFULLY',	'Message sent successfully',	'".$language."',	'Message sent successfully'),
				('UNSORT',	'Unsort',	'".$language."',	'Unsort'),
				('FILTER',	'Filter',	'".$language."',	'Filter'),
				('SORT_BY_DESC',	'Sort by DESC',	'".$language."',	'Sort by DESC'),
				('SORT_BY_ASC',	'Sort by ASC',	'".$language."',	'Sort by ASC'),
				('PREVIEW_NOT_SUPPORTED',	'Preview not supported',	'".$language."',	'Preview not supported'),
				('RECORD_EDITED_SUCCESSFULLY',	'Record edited successfully',	'".$language."',	'Record edited successfully'),
				('NO_RECORD_FOUND_IN_THIS_MODULE',	'No Record found for this module',	'".$language."',	'No Record found for this module'),
				('PLEASE_ENTER_A_VALID_VALUE',	'Please enter valid value',	'".$language."',	'Please enter valid value'),
				('SHOW_MORE',	'Show more',	'".$language."',	'Show more'),
				('SHOW_LESS',	'Show less',	'".$language."',	'Show less'),
				('LICENSE_REACTIVATION_MSG',	'It seems license is not activated or extension is not configured yet.',	'".$language."',	'It seems license is not activated or extension is not configured yet.'),
				('CLICK_HERE_TO_CONFIGURE',	'Click here to configure',	'".$language."',	'Click here to configure'),
				('YOU_DONT_HAVE_ACCESS_TO_ANY_MODULES',	'You do not have access to any modules',	'".$language."',	'You do not have access to any modules'),
				('YOU_DO_NOT_HAVE_ACCESS_TO_THIS_MODULE',	'You do not have access to this module',	'".$language."',	'You do not have access to this module'),
				('UNABLE_TO_SAVE_PLEASE_ENSURE_THAT_PHONE_NUMBER_IS_MANDATORY',	'Unable to Save (Please ensure that the phone number field is mandatory)',	'".$language."',	'Unable to Save (Please ensure that the phone number field is mandatory)'),
				('SORRY_YOU_CAN_NOT_LOGIN_THE_USER_INACTIVE',	'Sorry, You cannot login because the user is inactive',	'".$language."',	'Sorry, You cannot login because the user is inactive'),
				('MESSAGE_SENT',	'Message sent',	'".$language."',	'Message sent'),
				('SEARCH_RECORD',   'Search Record...', '".$language."',    'Search Record...'),
           		('HELP',    'Help', '".$language."',    'Help'),
           		('EDIT',    'Edit', '".$language."',    'Edit'),
           		('PHONE_CALL',    'a phone call', '".$language."',    'a phone call'),
           		('NUMBERS',    'Numbers', '".$language."',    'Numbers'),
           		('NUMBER',    'Number', '".$language."',    'Number'),
           		('SEARCH',    'Search', '".$language."',    'Search'),
           		('EDITING',    'Editing', '".$language."',    'Editing'),
           		('CALL_PLACE_FAILED',    'Call place failed', '".$language."',    'Call place failed'),
           		('TELEPHONY',    'Telephony', '".$language."',    'Telephony'),
           		('CONFIGURE_TELEPHONY_NUMBER',    'Please configure the Telephony Number', '".$language."',    'Please configure the Telephony Number'),
           		('CALL_PLACED_SUCCESSFULLY',    'Call Placed Successfully', '".$language."',    'Call Placed Successfully'),
           		('CALL_PLACE_IN_PROGRESS',    'Call Place In Progress', '".$language."',    'Call Place In Progress'),
           		('CALLING',    'Calling', '".$language."',    'Calling'),
           		('SELECT',    'Select', '".$language."',    'Select'),
           		('SEARCH',    'Search', '".$language."',    'Search'),
           		('PREVIEW_FILE',    'Preview File', '".$language."',    'Preview File'),
           		('SCHEDULE_MESSAGE_NOTIFICATION',    'Please note, the message will only be sent if the browser is open and user is logged in to CRM.', '".$language."',    'Please note, the message will only be sent if the browser is open and user is logged in to CRM.'),
           		('SCHEDULE_A_MESSAGE',    'Schedule a message', '".$language."',    'Schedule a message'),
           		('DAYS',    'Days', '".$language."',    'Days'),
           		('HOURS',    'Hours', '".$language."',    'Hours'),
           		('MINUTES',    'Minutes', '".$language."',    'Minutes'),
           		('ONCE_IN_EVERY',    'Once in every', '".$language."',    'Once in every'),
           		('DAY_OF_THE_MONTH',    'Day of the month', '".$language."',    'Day of the month'),
           		('ON',    'On', '".$language."',    'On'),
           		('UNTIL',    'Until', '".$language."',    'Until'),
           		('FIRST',    'First', '".$language."',    'First'),
           		('LAST',    'Last', '".$language."',    'Last'),
           		('SCHEDULING_MESSAGE_TO_CONTACTNUMBER',    'Scheduling message to contact number', '".$language."',    'Scheduling message to contact number'),
           		('EDIT_SCHEDULING_MESSAGE_TO_CONTACTNUMBER',    'Edit Scheduling Message to contact number', '".$language."',    'Edit Scheduling Message to contact number'),
           		('NAME',    'Name', '".$language."',    'Name'),
           		('CONTACT_NUMBER',    'Contact Number', '".$language."',    'Contact Number'),
           		('SCHEDULE_DATE',    'Schedule Date', '".$language."',    'Schedule Date'),
           		('SCHEDULE_TIME',    'Schedule Time', '".$language."',    'Schedule Time'),
           		('INVALID_WHATSAPP_NUMBER',    'Invalid Whatsapp Number 	', '".$language."',    'Invalid Whatsapp Number 	'),
           		('START_CHAT',    'Start Chat', '".$language."',    'Start Chat'),
           		('EDIT_SCHEDULED_MESSAGE',    'Edit Scheduled Message', '".$language."',    'Edit Scheduled Message'),
           		('SEND_NOW',    'Send Now', '".$language."',    'Send Now'),
           		('CANCEL_SCHEDULED_MESSAGE',    'Cancel Scheduled Message', '".$language."',    'Cancel Scheduled Message'),
           		('PLEASE_LOGIN',    'Please Login', '".$language."',    'Please Login'),
           		('FILE_SIZE_LIMIT',    'Max file size', '".$language."',    'Max file size'),
           		('COUNTRY_CODE',    'Country Code', '".$language."',    'Country Code'),
           		('FILE_SIZE_INVALID',    'Invalid file size', '".$language."',    'Invalid file size'),
           		('INVALID',    'Invalid', '".$language."',    'Invalid'),
           		('TALK_WITH_US',    'Talk with us', '".$language."',    'Talk with us'),
           		('SCHEDULEDMESSAGES',    'Scheduled Messages', '".$language."',    'Scheduled Messages'),
           		('SUN',    'Sun', '".$language."',    'Sun'),
           		('MON',    'Mon', '".$language."',    'Mon'),
           		('TUE',    'Tue', '".$language."',    'Tue'),
           		('WED',    'Wed', '".$language."',    'Wed'),
           		('THU',    'Thu', '".$language."',    'Thu'),
           		('FRI',    'Fri', '".$language."',    'Fri'),
           		('SAT',    'Sat', '".$language."',    'Sat'),
           		('SUNDAY',    'Sunday', '".$language."',    'Sunday'),
           		('MONDAY',    'Monday', '".$language."',    'Monday'),
           		('TUESDAY',    'Tuesday', '".$language."',    'Tuesday'),
           		('WEDNESDAY',    'Wednesday', '".$language."',    'Wednesday'),
           		('THURSDAY',    'Thursday', '".$language."',    'Thursday'),
           		('FRIDAY',    'Friday', '".$language."',    'Friday'),
           		('SATURDAY',    'Saturday', '".$language."',    'Saturday'),
           		('NO_OPTIONS',    'No Options', '".$language."',    'No Options'),
           		('PLEASE_DO_NOT_REFRESH_SCREEN',    'Please do not refresh Screen...', '".$language."',    'Please do not refresh Screen...'),
           		('UNTIL_DATE',    'Until Date', '".$language."',    'Until Date'),
           		('WEEKDAYS',    'Weekdays', '".$language."',    'Weekdays');");
        	 }
        }
    }

    static function addWidgetTo() {
        global $adb;
        $adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('WhatsApp Ext Setting'));
        $adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('WhatsApp Chrome - Settings'));
        $rsBlock=$adb->pquery("SELECT blockid FROM `vtiger_settings_blocks` WHERE label='LBL_OTHER_SETTINGS'",array());
        $blockid=$adb->query_result($rsBlock, 0, 'blockid');
        $max_id=$adb->getUniqueID('vtiger_settings_field');
        $adb->pquery("INSERT INTO `vtiger_settings_field` (`fieldid`, `blockid`, `name`, `description`, `linkto`, `sequence`) VALUES (?, ?, ?, ?, ?, ?)",array($max_id,$blockid,'WhatsApp Chrome - Settings', 'WhatsApp Chrome - Settings', 'index.php?module=CTWhatsAppExt&parent=Settings&view=Dashboard',$max_id));
        $adb->pquery("UPDATE vtiger_settings_field_seq SET id = ?",array($max_id));
    }
	
	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		
		$registerWSAPI = false; 
		$registerAlerts = false;
		
		if($event_type == 'module.postinstall') {
			$registerWSAPI = true;
			$registerAlerts= true;
			self::languageInit();
			self::addWidgetTo();
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			$registerWSAPI = true;
			$registerAlerts= true;
			self::languageInit();
			self::addWidgetTo();
		}
		
		// Register alerts
		if ($registerAlerts) {
			self::alert_register('modules/CTWhatsAppExt/api/ws/models/alerts/IdleTicketsOfMine.php', 'CTWhatsAppExt_WS_AlertModel_IdleTicketsOfMine');
			self::alert_register('modules/CTWhatsAppExt/api/ws/models/alerts/NewTicketOfMine.php', 'CTWhatsAppExt_WS_AlertModel_NewTicketOfMine');
			self::alert_register('modules/CTWhatsAppExt/api/ws/models/alerts/PendingTicketsOfMine.php', 'CTWhatsAppExt_WS_AlertModel_PendingTicketsOfMine');
			self::alert_register('modules/CTWhatsAppExt/api/ws/models/alerts/PotentialsDueIn5Days.php', 'CTWhatsAppExt_WS_AlertModel_PotentialsDueIn5Days');
			self::alert_register('modules/CTWhatsAppExt/api/ws/models/alerts/EventsOfMineToday.php', 'CTWhatsAppExt_WS_AlertModel_EventsOfMineToday');
			self::alert_register('modules/CTWhatsAppExt/api/ws/models/alerts/ProjectTasksOfMine.php','CTWhatsAppExt_WS_AlertModel_ProjectTasksOfMine');
			self::alert_register('modules/CTWhatsAppExt/api/ws/models/alerts/Projects.php','CTWhatsAppExt_WS_AlertModel_Projects');
		}
		
		// Register webservice API
		if($registerWSAPI) {
			$operations = array();
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.fetchallalerts',
				'handler'    => 'ctwhatsappext_ws_fetchAllAlerts',
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.alertdetailswithmessage',
				'handler'    => 'ctwhatsappext_ws_alertDetailsWithMessage',
				'parameters' => array( array( 'name' => 'alertid', 'type' => 'string' ) )
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.fetchmodulefilters',
				'handler'    => 'ctwhatsappext_ws_fetchModuleFilters',
				'parameters' => array( array( 'name' => 'module', 'type' => 'string' ) )
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.fetchrecord',
				'handler'    => 'ctwhatsappext_ws_fetchRecord',
				'parameters' => array( array( 'name' => 'record', 'type' => 'string' ) )
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.fetchrecordwithgrouping',
				'handler'    => 'ctwhatsappext_ws_fetchRecordWithGrouping',
				'parameters' => array( array( 'name' => 'record', 'type' => 'string' ) )
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.filterdetailswithcount',
				'handler'    => 'ctwhatsappext_ws_filterDetailsWithCount',
				'parameters' => array( array( 'name' => 'filterid', 'type' => 'string' ) )
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.listmodulerecords',
				'handler'    => 'ctwhatsappext_ws_listModuleRecords',
				'parameters' => array( array( 'name' => 'elements', 'type' => 'encoded' ) )
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.saverecord',
				'handler'    => 'ctwhatsappext_ws_saveRecord',
				'parameters' => array( array( 'name' => 'module', 'type' => 'string' ),
					array( 'name' => 'record', 'type' => 'string' ),
					array( 'name' => 'values', 'type' => 'encoded' ),
				)
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.syncModuleRecords',
				'handler'    => 'ctwhatsappext_ws_syncModuleRecords',
				'parameters' => array( array( 'name' => 'module', 'type' => 'string' ),
					array( 'name' => 'syncToken', 'type' => 'string' ),
					array( 'name' => 'page', 'type' => 'string' ),
				)
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.query',
				'handler'    => 'ctwhatsappext_ws_query',
				'parameters' => array( array( 'name' => 'module', 'type' => 'string' ),
					array( 'name' => 'query', 'type' => 'string' ),
					array( 'name' => 'page', 'type' => 'string' ),
				)
			);
			
			$operations[] = array (
				'name'       => 'ctwhatsappext.querywithgrouping',
				'handler'    => 'ctwhatsappext_ws_queryWithGrouping',
				'parameters' => array( array( 'name' => 'module', 'type' => 'string' ),
					array( 'name' => 'query', 'type' => 'string' ),
					array( 'name' => 'page', 'type' => 'string' ),
				)
			);
			
			foreach($operations as $o) {
				$operation = new CTWhatsAppExt_WS_Operation($o['name'], $o['handler'], 'modules/CTWhatsAppExt/api/wsapi.php', 'POST');
				if(!empty($o['parameters'])) {
					foreach($o['parameters'] as $p) {
						$operation->addParameter($p['name'], $p['type']);
					}
				}
				$operation->register();
			}
		}
	}
}

/* Helper functions */
class CTWhatsAppExt_WS_Operation {
	var $opName, $opClass, $opFile, $opType;
	var $parameters = array();
	
	function __construct($apiName, $className, $handlerFile, $reqType) {
		$this->opName = $apiName;
		$this->opClass= $className;
		$this->opFile = $handlerFile;
		$this->opType = $reqType;
	}
	
	function addParameter($name, $type) {
		$this->parameters[] = array('name' => $name, 'type' => $type);
		return $this;
	}
	
	function register() {
		global $adb;
		$checkresult = $adb->pquery("SELECT 1 FROM vtiger_ws_operation WHERE name = ?", array($this->opName));
		if($adb->num_rows($checkresult)) {
			return;
		}
		
		Vtiger_Utils::Log("Enabling webservice operation {$this->opName}", true);
		
		$operationid = vtws_addWebserviceOperation($this->opName, $this->opFile, $this->opClass, $this->opType);
		for($index = 0; $index < count($this->parameters); ++$index) {
			vtws_addWebserviceOperationParam($operationid, $this->parameters[$index]['name'], $this->parameters[$index]['type'], ($index+1));
		}
	}
}
	
?>
