<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTWhatsAppExt_Deactivate_Action extends Settings_Vtiger_Basic_Action {
	
    public function process(Vtiger_Request $request) {
        global $adb,$site_URL;
        $license_key = $request->get('license_key');
        $domain = $request->get('domain');
        $getLicenseQuery = $adb->pquery("SELECT * FROM ctwhatsappext_license_settings",array());
        $numOfLicenseCount = $adb->num_rows($getLicenseQuery);
		if($numOfLicenseCount > 0){
			if($license_key == "" && $domain == ""){
				$license_key=$adb->query_result($getLicenseQuery,0,'license_key');
				$domain=$adb->query_result($getLicenseQuery,0,'domain');
			}
		}

		$url = 'https://crmtiger.com/whatsapp/checklicensewaextension.php';
		$serviceURL = $url;
		$postData = array( "license_key"=>$license_key,"domain"=>$domain,"action"=>"deactivate");
		
		$ch = curl_init($url);
		$agent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)';
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $postData );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_USERAGENT, $agent);
		$res_license = curl_exec($ch);
		curl_close($ch);
		$result_response = json_decode($res_license,true);
		
		//$result_response = json_decode($result,true);
		if($result_response['message'] == 'Deactivated'){
			$deleteLicense = $adb->pquery("DELETE FROM ctwhatsappext_license_settings",array());		
			$response = new Vtiger_Response();
			$response->setEmitType(Vtiger_Response::$EMIT_JSON);
			$response->setResult(array("message"=>vtranslate('MSG_DEACTIVATE_LICENSE','CTWhatsAppExt')));
			$response->emit();
		}else{
			$response = new Vtiger_Response();
			$response->setEmitType(Vtiger_Response::$EMIT_JSON);
			$response->setResult(array("message"=>vtranslate('License Deactivation Failed','CTWhatsAppExt')));
			$response->emit();
		}
       
    }
}

?>
