	<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTWhatsAppExt_SaveCountryCode_Action extends Settings_Vtiger_Basic_Action {
    
	public function process(Vtiger_Request $request) {
		global $adb,$site_URL;
		$getLicenseQuery=$adb->pquery("SELECT * FROM ctwhatsappext_countrycode_settings");
		$numOfLicenseCount = $adb->num_rows($getLicenseQuery);
		$country_code = trim($request->get('country_code'));
		
		if($numOfLicenseCount > 0){
			$record=$adb->query_result($getLicenseQuery,0,'id');
			$query=$adb->pquery("UPDATE ctwhatsappext_countrycode_settings SET country_code=? WHERE id=?",array($country_code,$record));
			if($query){
				$result = array('code'=>2, 'msg'=>vtranslate('Country Code Updated Successfully','CTWhatsAppExt'));
			}
		}else{
			$query=$adb->pquery("INSERT INTO ctwhatsappext_countrycode_settings (country_code) values(?)",array($country_code));
			if($query){
				$result = array('code'=>1, 'msg'=>vtranslate('Country Code Inserted Successfully','CTWhatsAppExt'));
			}
		}	
		$response = new Vtiger_Response();
		$response->setEmitType(Vtiger_Response::$EMIT_JSON);
		$response->setResult($result);
		$response->emit();
	}
}
?>
