<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTWhatsAppExt_SaveLanguageAjax_Action extends Vtiger_Save_Action {
    public function process(Vtiger_Request $request) {
        global $adb;
        $ctlanguage = $request->get('ctlanguage');
        $LanguageFields = $this->getLanguageFields($ctlanguage);
        if($LanguageFields){
            foreach($LanguageFields as $key => $languageField){
                $keyword_id = $languageField['keyword_id'];
                $language_keyword = $request->get('field_'.$keyword_id);
                $adb->pquery("UPDATE ctwhatsappext_language_keyword SET language_keyword = ? WHERE keyword_id = ?",array($language_keyword,$keyword_id));
            }
        }
        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult(array('ctlanguage'=>$ctlanguage));
        $response->emit();
    }

    public function getLanguageFields($language){
        global $adb;
        $query = "SELECT * FROM ctwhatsappext_language_keyword WHERE keyword_lang = ? ";
        $results = $adb->pquery($query,array($language));
        $numRows = $adb->num_rows($results);
        $fields = array();
        if($numRows){
            for($i=0;$i<$numRows;$i++){
                $keyword_id = $adb->query_result($results,$i,'keyword_id');
                $keyword_name = $adb->query_result($results,$i,'keyword_name');
                $language_keyword = $adb->query_result($results,$i,'language_keyword');
                $fields[] = array('keyword_id'=>$keyword_id,'keyword_name'=>$keyword_name,'language_keyword'=>$language_keyword);
            }
        }
        return $fields;
    }
}
