	<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTWhatsAppExt_SaveLicense_Action extends Settings_Vtiger_Basic_Action {
    
	public function process(Vtiger_Request $request) {
		global $adb,$site_URL;
		$getLicenseQuery=$adb->pquery("SELECT * FROM ctwhatsappext_license_settings");
		$numOfLicenseCount = $adb->num_rows($getLicenseQuery);
		$License_Key = trim($request->get('license_key'));
		$numofUsers = $this->getTotalCrmUsers();
		//$url = 'https://ctapps.crmtiger.com/checklicense.php';
		$url = 'https://crmtiger.com/whatsapp/checklicensewaextension.php';
		$ch = curl_init($url);
		//$data = array();
		$agent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)';
		$data = array( "license_key"=>$License_Key,"domain"=>$site_URL,"action"=>"activate",'num_of_crm_user'=>$numofUsers);
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_USERAGENT, $agent);
		$res_license = curl_exec($ch);
		curl_close($ch);
		$result_response = json_decode($res_license,true);
		
		if($result_response['Apirespocetype'] == 1){
			//$premiumUserType = array('Monthly','One Time','Yearly');
			$user_type = $result_response['type'];
			//$expirydate = $result_response['expirydate'];
			$apikey = $this->encrypt_decrypt($result_response['expirydate'],'e');
			/*if(in_array($user_type,$premiumUserType)){
				$user_type = 'premium';
			}else{
				$user_type = 'free';
			}*/
			if($numOfLicenseCount > 0){
				$record=$adb->query_result($getLicenseQuery,0,'id');
				$query=$adb->pquery("UPDATE ctwhatsappext_license_settings SET license_key=?, domain=?, apikey=?, user_type=? WHERE id=?",array($License_Key, $site_URL, $apikey, $user_type, $record));
				if($query){
					$result = array('code'=>2, 'msg'=>vtranslate('License Key Updated Successfully','CTWhatsAppExt'));
				}
			}else{
				$query=$adb->pquery("INSERT INTO ctwhatsappext_license_settings (license_key,status,domain,apikey,user_type) values(?,?,?,?,?)",array($License_Key,1,$site_URL,$apikey,$user_type));
				if($query){
					$result = array('code'=>1, 'msg'=>vtranslate('License Key Inserted Successfully','CTWhatsAppExt'));
				}
			}	

						 
													   
		}else if($result_response['Apirespocetype'] == 3 && $result_response['message'] == 'Already activated'){
			$record=$adb->query_result($getLicenseQuery,0,'id');
			$query=$adb->pquery("UPDATE ctwhatsappext_license_settings SET license_key=?, domain=?, apikey=?, user_type=? WHERE id=?",array($License_Key, $site_URL, $apikey, $user_type, $record));
			$result = array('code'=>3, 'msg'=>vtranslate('License Key Updated Successfully','CTWhatsAppExt'));
		}else if($result_response['Apirespocetype'] == 4){
			$result = array('code'=>103, 'msg'=>$result_response['message'],"domain"=>$result_response['domain'],"license_key"=>$License_Key);
		}else{
			$result = array('code'=>100, 'msg'=>$result_response['message']);
		}
		$response = new Vtiger_Response();
		$response->setEmitType(Vtiger_Response::$EMIT_JSON);
		$response->setResult($result);
		$response->emit();
	}

	function getTotalCrmUsers(){
		global $adb;
		$Users = $adb->pquery("SELECT * FROM `vtiger_users` WHERE deleted = 0 AND status = ?",array('Active'));
		$numofUsers = $adb->num_rows($Users);
		return $numofUsers;
	}

	public function encrypt_decrypt( $string, $action = 'e' ) {
		// you may change these values to your own
		$secret_key = 'variance12*';
		$secret_iv = 'variance12*';

		$output = false;
		$encrypt_method = "AES-256-CBC";
		$key = hash( 'sha256', $secret_key );
		$iv = substr( hash( 'sha256', $secret_iv ), 0, 16 );

		if( $action == 'e' ) {
		$output = base64_encode( openssl_encrypt( $string, $encrypt_method, $key, 0, $iv ) );
		}
		else if( $action == 'd' ){
		$output = openssl_decrypt( base64_decode( $string ), $encrypt_method, $key, 0, $iv );
		}

		return $output;
	}
}
?>
