	<?php
/*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */
class CTWhatsAppExt_SaveMaxNumberDigit_Action extends Settings_Vtiger_Basic_Action {
	public function process(Vtiger_Request $request) {
		global $adb, $site_URL;
		$maxNumberDigit = trim($request->get('maxNumberDigit'));

		$getMaxNumberDigitData = $adb->pquery("SELECT * FROM ctwhatsappext_phonenumberdigit_settings");
		$numOfNumberDigit = $adb->num_rows($getMaxNumberDigitData);

		if($numOfNumberDigit > 0){
			$record = $adb->query_result($getMaxNumberDigitData, 0, 'id');
			$query = $adb->pquery("UPDATE ctwhatsappext_phonenumberdigit_settings SET max_number_digit=? WHERE id=?", array($maxNumberDigit, $record));
			if($query){
				$result = array('message' => vtranslate('Max. Phone Number Digit Updated Successfully', 'CTWhatsAppExt'));
			}//end of if
		}else{
			$query = $adb->pquery("INSERT INTO ctwhatsappext_phonenumberdigit_settings (max_number_digit) values(?)", array($maxNumberDigit));
			if($query){
				$result = array('message' => vtranslate('Max. Phone Number Digit Inserted Successfully', 'CTWhatsAppExt'));
			}//end of if
		}//end of else

		$response = new Vtiger_Response();
		$response->setEmitType(Vtiger_Response::$EMIT_JSON);
		$response->setResult($result);
		$response->emit();
	}//end of fuction
}//end of class
?>