<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTWhatsAppExt_WS_FetchCountOfFilter extends CTWhatsAppExt_WS_Controller {
	
	function process(CTWhatsAppExt_API_Request $request) {
		global $adb,$site_URL,$current_user;
		$response = new CTWhatsAppExt_API_Response();
		$current_user = $this->getActiveUser();

		$module = trim($request->get('module'));
		$filterid = $request->get('filterid');
		if($module == ''){
			$message = 'module is required !';
			throw new WebServiceException(404,$message);
		}
		if($filterid == ''){
			$message = 'filterid is required !';
			throw new WebServiceException(404,$message);
		}
		$generator = new QueryGenerator($module, $current_user);
		$generator->initForCustomViewById($filterid);
		$query = $generator->getQuery();

		$query1 = explode('FROM', $query);
		$totalQuery = "SELECT 1 FROM ".$query1[1];

		$totalResults = $adb->pquery($totalQuery,array());
		$totalRecords = $adb->num_rows($totalResults);
		$response->setResult(array('count'=>$totalRecords));
		return $response;
	}
}
