<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTWhatsAppExt_WS_FetchModuleFilters extends CTWhatsAppExt_WS_Controller {
	
	function process(CTWhatsAppExt_API_Request $request) {
		global $adb,$site_URL;
		$response = new CTWhatsAppExt_API_Response();

		$module = trim($request->get('module'));
		if($module == 'Events'){
			$module = 'Calendar';
		}
		$current_user = $this->getActiveUser();
		
		$result = array();
		
		$filters = $this->getModuleFilters($module, $current_user);
		$moduleModel = Vtiger_Module_Model::getInstance($module);
		$LISTVIEW_URL = $moduleModel->getListViewUrl();
		$yours = array();
		$others= array();
		if(!empty($filters)) {
			foreach($filters as $filter) {
				$filter['link'] = $site_URL.$LISTVIEW_URL.'&viewname='.$filter['cvid'];
				if($filter['userName'] == $current_user->column_fields['user_name']) {
					$yours[] = $filter;
				} else {
					$others[]= $filter;
				}
			}
		}
		$filters = array_merge($yours,$others);
		$filter = $filters;
		foreach($filter as $key => $value){
			$filters[$key]['isDefault'] = 0;
			$tabId = getTabid($module); 
			$result = $adb->pquery('SELECT default_cvid FROM vtiger_user_module_preferences WHERE userid = ? AND tabid = ?',
				array($current_user->id, $tabId));
			if($adb->num_rows($result) > 0) {
				$cvId = $adb->query_result($result, 0, 'default_cvid');
				if($cvId === $value['cvid']) {
					$filters[$key]['isDefault'] = 1;
				} else {
					$filters[$key]['isDefault'] = 0;
				}
			}
		}
		$results['filters'] = array('yours' => $filters);
		if(count($filters) == 0){
			$results['code'] = 404;
			$results['message'] = vtranslate('LBL_NO_RECORDS_FOUND','Vtiger');
			$response->setResult($results);
		}else{
			$response->setResult($results);
		}

		return $response;
	}

	protected function getModuleFilters($moduleName, $user) {
		global $current_user;
		$current_user = $this->getActiveUser();
		$filters = array();
		
		global $adb;
			$sql = "SELECT vtiger_customview.*, vtiger_users.user_name FROM vtiger_customview 
				INNER JOIN vtiger_users ON vtiger_customview.userid = vtiger_users.id WHERE vtiger_customview.entitytype=?";
		$params = array($moduleName);

		$userPrivilegeModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
		$currentUser = Users_Record_Model::getCurrentUserModel();

		if(!$userPrivilegeModel->isAdminUser()) {
			$userGroups = new GetUserGroups();
			$userGroups->getAllUserGroups($currentUser->getId());
			$groups = $userGroups->user_groups;
			$userRole = fetchUserRole($currentUser->getId());
			$parentRoles=getParentRole($userRole);
			$parentRolelist= array();
			foreach($parentRoles as $par_rol_id) {
				array_push($parentRolelist, $par_rol_id);		
			}
			array_push($parentRolelist, $userRole);

			$userParentRoleSeq = $userPrivilegeModel->get('parent_role_seq');
			$sql .= " AND ( vtiger_customview.userid = ? OR vtiger_customview.status = 0 OR vtiger_customview.status = 3
							OR vtiger_customview.userid IN (
								SELECT vtiger_user2role.userid FROM vtiger_user2role
									INNER JOIN vtiger_users ON vtiger_users.id = vtiger_user2role.userid
									INNER JOIN vtiger_role ON vtiger_role.roleid = vtiger_user2role.roleid
								WHERE vtiger_role.parentrole LIKE '".$userParentRoleSeq."::%') 
							OR vtiger_customview.cvid IN (SELECT vtiger_cv2users.cvid FROM vtiger_cv2users WHERE vtiger_cv2users.userid=?)";
			$params[] = $currentUser->getId();
			$params[] = $currentUser->getId();
			if(!empty($groups)){
				$sql .= "OR vtiger_customview.cvid IN (SELECT vtiger_cv2group.cvid FROM vtiger_cv2group WHERE vtiger_cv2group.groupid IN (".  generateQuestionMarks($groups)."))";
				$params = array_merge($params,$groups);
			}

			$sql.= "OR vtiger_customview.cvid IN (SELECT vtiger_cv2role.cvid FROM vtiger_cv2role WHERE vtiger_cv2role.roleid =?)";
			$params[] = $userRole;
			if(!empty($parentRolelist)){
				$sql.= "OR vtiger_customview.cvid IN (SELECT vtiger_cv2rs.cvid FROM vtiger_cv2rs WHERE vtiger_cv2rs.rsid IN (". generateQuestionMarks($parentRolelist) ."))";
				$params = array_merge($params,$parentRolelist);
			}

			$sql.= ")";
		}
		$result = $adb->pquery($sql, $params);
		if($result && $adb->num_rows($result)) {
			while($resultrow = $adb->fetch_array($result)) {
				$filters[] = $this->prepareFilterDetailUsingResultRow($resultrow, $moduleName, $user);
			}
		}	
		return $filters;
	}
	
	protected function prepareFilterDetailUsingResultRow($resultrow, $moduleName, $user) {
		$filter = array();
		$filter['cvid'] = $resultrow['cvid'];
		$filter['viewname'] = vtranslate(decode_html($resultrow['viewname']), $moduleName, $user->language);
		$filter['setdefault'] = $resultrow['setdefault'];
		$filter['setmetrics'] = $resultrow['setmetrics'];
		$filter['moduleName'] = decode_html($resultrow['entitytype']);
		$filter['status']     = decode_html($resultrow['status']);
		$filter['userName']   = decode_html($resultrow['user_name']);
		return $filter;
	}
}
