<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTWhatsAppExt_WS_FindNumberRecord extends CTWhatsAppExt_WS_Controller {
	function process(CTWhatsAppExt_API_Request $request) {
		$number = $request->get('number');
		$response = new CTWhatsAppExt_API_Response();
		if ($number != '') {
			global $current_user,$adb, $site_URL;
			$current_user = $this->getActiveUser();
			$presence = array('0', '2');
			$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);

			//Get Max. Phone Number Digit
			$getMaxNumberDigitData = $adb->pquery("SELECT * FROM ctwhatsappext_phonenumberdigit_settings");
			$numOfNumberDigit = $adb->num_rows($getMaxNumberDigitData);

	        if($numOfNumberDigit > 0){
				$maxNumberDigit = $adb->query_result($getMaxNumberDigitData, 0, 'max_number_digit');
			}//end of if

			if($maxNumberDigit == ''){
				$maxNumberDigit = 10;
			}//end of if

			$number = substr($number,-$maxNumberDigit);

			$setypeModules = array('Accounts','Contacts','Leads');
			$ModulePhoneField = array();
			foreach ($setypeModules as $key => $semodule) {
				$semoduleModel = Vtiger_Module_Model::getInstance($semodule);
				if (($userPrivModel->isAdminUser() ||
										$userPrivModel->hasGlobalReadPermission() ||
										$userPrivModel->hasModulePermission($semoduleModel->getId())) && in_array($semoduleModel->get('presence'), $presence)) {
					$moduleFields = $semoduleModel->getFields();

					foreach ($moduleFields as $skey => $fieldModel) {
						if($fieldModel->get('uitype') == '11' && in_array($fieldModel->get('presence'), $presence)){
							$ModulePhoneField[$semodule][] = $fieldModel->get('name');
						}//end of if
					}//end of foreach

					$phoneFields = $ModulePhoneField[$semodule];
					$ModulePhoneField[$semodule][] = 'id';
					$queryGenerator = new EnhancedQueryGenerator($semodule, $current_user);
            		$queryGenerator->setFields($ModulePhoneField[$semodule]);
					$query = $queryGenerator->getQuery();
					foreach ($phoneFields as $mkey => $phonefield) {
            			$fieldModel = $moduleFields[$phonefield];
            			$tablename = $fieldModel->get('table');
            			$column = $fieldModel->get('column');
            			
            			if($mkey == 0){
            				$query.=" AND ( ";
            				$query.=" ( REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE($tablename.$column,'-', ''), ' ', ''), '(', ''), ')', ''), '+', ''), '.', ''), '/', '') LIKE '%$number' ) ";
            				//$query.=" ( REPLACE($tablename.$column,'-', '') LIKE '%$number' ) ";
            			}else{
            				//$query.=" OR ( REPLACE($tablename.$column,'-', '') LIKE '%$number' ) ";
            				$query.=" OR ( REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE($tablename.$column,'-', ''), ' ', ''), '(', ''), ')', ''), '+', ''), '.', ''), '/', '') LIKE '%$number' ) ";
            			}//end of else
            			if($mkey+1 ==  count($phoneFields)){
            				$query.=" ) ";
            			}//end of if
            		}//end of foreach
            		
            		$results = $adb->pquery($query);
					$numRows = $adb->num_rows($results);

					for ($i=0; $i < $numRows; $i++) { 
	            		$module = $semodule;
						$row = $adb->query_result_rowdata($results,$i);
						$basetableid = $semoduleModel->get('basetableid');
						$crmid = $row[$basetableid];
						foreach ($phoneFields as $vkey => $phonefield) {
	            			if($row[$phonefield] == $number){
	            				$fieldname = $phonefield;
	            				break;
	            			}
	            		}

	            		$moduleWSId = CTWhatsAppExt_WS_Utils::getEntityModuleWSId($module);
	            		if (($userPrivModel->isAdminUser() ||
										$userPrivModel->hasGlobalReadPermission() ||
										$userPrivModel->hasModulePermission($semoduleModel->getId())) && in_array($semoduleModel->get('presence'), $presence)) {
							if(!$this->is_deleted($crmid)){
								$recordPermission = Users_Privileges_Model::isPermitted($module, 'DetailView', $crmid);
								$recordEntityName = getSalesEntityType($crmid);
								if($recordPermission && $recordEntityName == $module) {
									$recordModel = Vtiger_Record_Model::getInstanceById($crmid,$module);
									$Fields = $semoduleModel->getSummaryViewFieldsList();
									$summaryFields = array_keys($Fields);
									if(!in_array($fieldname,$summaryFields)){
										$summaryFields = array_merge($summaryFields,array($fieldname));
									}
									$data[$module]['id'] = $moduleWSId.'x'.$crmid;
									$record = explode('x',$data[$module]['id']);
									$ActionData = $this->getActionData($module,$record);
									foreach ($ActionData as $nkey => $value) {
										$data[$module][$nkey] = $value;
									}
									foreach($summaryFields as $nkey => $value){
										$data[$module][$value] = $recordModel->get($value);
									}
								}
							}
						}
	            	}//end of for

				}//end of if
			}//end of foreach

			/*$query = "SELECT DISTINCT(crmid) as recordid, setype,fieldname FROM `vtiger_pbxmanager_phonelookup` WHERE `fnumber` LIKE '%$number%' OR `rnumber` LIKE '%$number%'";

			$results = $adb->pquery($query);
			$numRows = $adb->num_rows($results);
			for ($i=0; $i < $numRows; $i++) { 
				$module = $adb->query_result($results,$i,'setype');
				$crmid = $adb->query_result($results,$i,'recordid');
				$fieldname = $adb->query_result($results,$i,'fieldname');
				$moduleWSId = CTWhatsAppExt_WS_Utils::getEntityModuleWSId($module);
				$moduleModel = Vtiger_Module_Model::getInstance($module);
				if (($userPrivModel->isAdminUser() ||
								$userPrivModel->hasGlobalReadPermission() ||
								$userPrivModel->hasModulePermission($moduleModel->getId())) && in_array($moduleModel->get('presence'), $presence)) {
					if(!$this->is_deleted($crmid)){
						$recordModel = Vtiger_Record_Model::getInstanceById($crmid,$module);
						$Fields = $moduleModel->getSummaryViewFieldsList();
						$summaryFields = array_keys($Fields);
						if(!in_array($fieldname,$summaryFields)){
							$summaryFields = array_merge($summaryFields,array($fieldname));
						}
						$data[$module]['id'] = $moduleWSId.'x'.$crmid;
						$record = explode('x',$data[$module]['id']);
						$ActionData = $this->getActionData($module,$record);
						foreach ($ActionData as $key => $value) {
							$data[$module][$key] = $value;
						}
						foreach($summaryFields as $key => $value){
							$data[$module][$value] = $recordModel->get($value);
						}
					}
				}
			}*/
			
			if(count($data) > 0){
				$response->setResult($data);
			}else{
				$response->setError('','No Records Found');
			}
			
		}else{
			throw new WebServiceException(404,"Required field is missing");	
		}
		return $response;
	}

	public function is_deleted($crmid){
	 	global $adb;
	 	$query = "SELECT * FROM vtiger_crmentity WHERE crmid = ? AND deleted = 0";
	 	$result = $adb->pquery($query,array($crmid));
	 	if($adb->num_rows($result)){
	 		return false;
	 	}else{
	 		return true;
	 	}

	}

	public function getActionData($module,$record){
		global $site_URL;
		$moduleModel = Vtiger_Module_Model::getInstance($module); 
		$recordModel = Vtiger_Record_Model::getInstanceById($record[1],$module);
		$editAction = Users_Privileges_Model::isPermitted($module, 'EditView', $record[1]);
		if($moduleModel->isSummaryViewSupported()) {
			$isSummarySupported = true;
			$summaryLinkurl = $site_URL.$recordModel->getDetailViewUrl().'&mode=showDetailViewByMode&requestMode=summary';
		}else{
			$isSummarySupported = false;
			$summaryLinkurl = $site_URL.$recordModel->getDetailViewUrl();
		}
		$modCommentsModel = Vtiger_Module_Model::getInstance('ModComments');
		if($moduleModel->isCommentEnabled() && $modCommentsModel->isPermitted('DetailView')){
			$CommentDetailPermission = true;
		}else{
			$CommentDetailPermission = false;
		}
		if($moduleModel->isCommentEnabled() && $modCommentsModel->isPermitted('CreateView')){
			$CommentCreatePermission = true;
		}else{
			$CommentCreatePermission = false;
		}
	   	$recordlist = array('module'=>$module,'id'=>$record[0].'x'.$record[1],'isSummarySupported'=>$isSummarySupported,'summaryLinkurl'=>$summaryLinkurl,'isEditSupported'=>$editAction,'CommentCreatePermission'=>$CommentCreatePermission,'CommentDetailPermission'=>$CommentDetailPermission);
	   	return $recordlist;
	}
}
