<?php

class CTWhatsAppExt_WS_GetScheduleMessage extends CTWhatsAppExt_WS_Controller {
	function process(CTWhatsAppExt_API_Request $request) {

		global $adb;
		$senderId = $request->get('scheduledby');
		$msgId = $request->get('msgId');
		$crmUserId = $request->get('crmuserid');

		if($msgId){
			$getMessageQuery = $adb->pquery("SELECT * FROM ctwhatsappext_waschedulemessages WHERE senderid = ? AND msgid = ? AND crmuserid = ? AND isactive = ?", array($senderId, $msgId, $crmUserId, 0));
		}else{
			$getMessageQuery = $adb->pquery("SELECT msgid, senderid, receiverid, messagesenddate, messagesendtime, message, attachedfilename, isactive FROM ctwhatsappext_waschedulemessages WHERE senderid = ? AND crmuserid = ? AND isactive = ?", array($senderId, $crmUserId, 0));
		}
		
		$numRows = $adb->num_rows($getMessageQuery);
		$scheduleMessageData = array();
		if($numRows > 0){
			for($i=0; $i<$numRows; $i++){
				$msgId = $adb->query_result($getMessageQuery, $i, 'msgid');
				$senderId = $adb->query_result($getMessageQuery, $i, 'senderid');
				$receiverId = $adb->query_result($getMessageQuery, $i, 'receiverid');
				$crmUserId = $adb->query_result($getMessageQuery, $i, 'crmuserid');
				$msgSendDate = $adb->query_result($getMessageQuery, $i, 'messagesenddate');
				$msgSendTime = $adb->query_result($getMessageQuery, $i, 'messagesendtime');
				$message = $adb->query_result($getMessageQuery, $i, 'message');
				$fileName = $adb->query_result($getMessageQuery, $i, 'attachedfilename');
				//$decodedMsg = json_decode($message);
				if($msgId){
					$fileData = $adb->query_result($getMessageQuery, $i, 'attachedfiledata');
				}//end of if
				$isActive = $adb->query_result($getMessageQuery, $i, 'isactive');

				$message = json_decode(html_entity_decode($message, ENT_QUOTES | ENT_HTML5));
				$message = str_replace(['&gt;', '&lt;', '&amp;'], ['>', '<', '&'], $message);

				if($msgId){	
					$scheduleMessageData[] = array('msgId'=>$msgId, 'senderId'=>$senderId, 'receiverId'=>$receiverId, 'crmUserId' => $crmUserId, 'msgSendDate'=>$msgSendDate, 'msgSendTime'=>$msgSendTime, 'message'=> $message, 'filename'=>$fileName, 'fileData'=>$fileData, 'isActive'=>$isActive);
				}else{
					$scheduleMessageData[] = array('msgId'=>$msgId, 'senderId'=>$senderId, 'receiverId'=>$receiverId, 'crmUserId' => $crmUserId, 'msgSendDate'=>$msgSendDate, 'msgSendTime'=>$msgSendTime, 'message'=> $message, 'filename'=>$fileName, 'isActive'=>$isActive);
				}//end of else
			}//end of for
		}//end of if
		$response = new CTWhatsAppExt_API_Response();
		$response->setResult($scheduleMessageData);
		
		return $response;
	}//end of Function
}

?>