<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

include_once dirname(__FILE__) . '/models/Alert.php';
include_once dirname(__FILE__) . '/models/SearchFilter.php';
include_once dirname(__FILE__) . '/models/Paging.php';

class CTWhatsAppExt_WS_ListModuleRecords extends CTWhatsAppExt_WS_Controller {
	function isCalendarModule($module) {
		return ($module == 'Events' || $module == 'Calendar');
	}
	
	function getSearchFilterModel($module, $search) {
		return CTWhatsAppExt_WS_SearchFilterModel::modelWithCriterias($module, Zend_JSON::decode($search));
	}
	
	function getPagingModel(CTWhatsAppExt_API_Request $request) {
		$page = $request->get('page', 0);
		return CTWhatsAppExt_WS_PagingModel::modelWithPageStart($page);
	}
	
	function process(CTWhatsAppExt_API_Request $request) {
		
		return $this->processSearchRecordLabel($request);
	}

	function GroupDetails($pagingModel,$paging){
		global $adb;
		$index = $paging['index'];
		$size = $paging['size'];
		$limit = ($index*$size) - $size;
		$query = "SELECT * FROM vtiger_groups";
		if($index != '' && $size != '') {
			$query .= sprintf(" LIMIT %s, %s", $limit, $size);
		}
		$prequeryResult = $adb->pquery($query,array());
		$result = new SqlResultIterator($adb, $prequeryResult);
		$i = 0;
		foreach($result as $record) {
			if ($record instanceof SqlResultIteratorRow) {
				$record = $record->data;
				$modifiedRecord[$i]['assigned_user_id'] = $modifiedRecord[$i]['modifiedtime'] = $modifiedRecord[$i]['label'] = $modifiedRecord[$i]['id'] = null;
				foreach($record as $key => $values){
					$modifiedRecord[$i]['modifiedtime']= null;
					$modifiedRecord[$i]['assigned_user_id'] = null;
					if($key == 'groupid'){
						$modifiedRecord[$i]['id'] = '20x'.$values;
					}else if($key == 'groupname'){
						$modifiedRecord[$i]['label'] = $values;
					}
				}
			}
			$i =$i+1;
		}
		return $modifiedRecord;
	}
	
	function processSearchRecordLabel(CTWhatsAppExt_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user, $adb, $site_URL; // Few core API assumes this variable availability
		$CRM_SITE_URL = $site_URL;
		if(substr($CRM_SITE_URL, -1) != '/'){
			$CRM_SITE_URL = $CRM_SITE_URL.'/';
		}
		$current_user = $this->getActiveUser();
		
		$module = trim($request->get('module'));
		$alertid = trim($request->get('alertid'));
		$filterid = $request->get('filterid');
		$search = trim($request->get('search'));
		$index = trim($request->get('index'));
		$size = trim($request->get('size'));
		$type = trim($request->get('type'));
		$field_name = trim($request->get('field_name'));
		$field_value = trim($request->get('field_value'));
		$field_compare = trim($request->get('field_compare'));
		$searchwithor = trim($request->get('searchwithor'));
		$order_by = trim($request->get('order_field'));
		$orderby = trim($request->get('orderby'));
		$display_params = $request->get('display_params');
		$params = Zend_Json::decode($display_params);
		//echo "<pre>";print_r($params);exit;
		$user_type = trim($request->get('user_type'));
		$entity_key = trim($request->get('entity_key'));
		$related = trim($request->get('related'));
		$discontinued = trim($request->get('discontinued'));
		$getCount = trim($request->get('getCount'));
		if(empty($discontinued)){
			$discontinued = 0;
		}
		if(!getTabid($module)){
			$message = vtranslate($module,$module)." ".vtranslate('Module does not exists','CTWhatsAppExt');
			throw new WebServiceException(404,'"'.vtranslate($module,$module).'" Module does not exists');
		}

		if($searchwithor == 'false'){
			$searchwithor = false;
		}
		
		if($module == 'Groups'){
			$pagingModel = $this->getPagingModel($request);
			$paging = array('index'=>$index, 'size'=>$size);
			$modifiedRecords = array();
			$modifiedRecords = $this->GroupDetails($pagingModel,$paging);
			$response = new CTWhatsAppExt_API_Response();
			if(count($modifiedRecords) == 0) {
				$response->setResult(array('records'=>$modifiedRecords, 'module'=>$module, 'message'=>vtranslate('LBL_NO_RECORDS_FOUND','Vtiger'),'module_record_status'=>false));
			} else {
				$response->setResult(array('records'=>$modifiedRecords, 'module'=>$module, 'message'=>'','module_record_status'=>true));
			}
			return $response;
		}
		
		
		$userId = array();
		$moduleModel = Vtiger_Module_Model::getInstance($module);
		$fieldModels = $moduleModel->getFields();
		$Modulefields = array_keys($fieldModels);
		$refrenceUitypes = array(10,51,57,58,59,66,73,75,76,78,80,81,101);
		//start validation of fieldname by suresh
		/*if(!empty($field_name) && !in_array($field_name,$Modulefields)){
			$message = vtranslate($field_name,$module)." ".vtranslate('Field does not exists','CTWhatsAppExt');
			throw new WebServiceException(404,$message);
		}*/
		if(!empty($order_by) && !in_array($order_by,$Modulefields)){
			$message = vtranslate($order_by,$module)." ".vtranslate('Field does not exists','CTWhatsAppExt');
			throw new WebServiceException(404,$message);
		}
		/*if($field_name){
			$uitype = $fieldModels[$field_name]->get('uitype');
		}*/
		foreach($params as $fieldname){
			if(!empty($fieldname) && !in_array($fieldname,$Modulefields)){
				$message = vtranslate($fieldname,$module)." ".vtranslate('Field does not exists','CTWhatsAppExt');
				throw new WebServiceException(404,$message);
			}
		}//end validation of fieldname

		$summaryViewFieldsList = $moduleModel->getSummaryViewFieldsList();
		$fieldlists = $moduleModel->getFields();
		$phoneNumberFields = array();
		foreach ($fieldlists as $fieldname => $field) {
			if($field->get('uitype') == 11){
				array_push($phoneNumberFields,$fieldname);
			}
		}

		$listHeaders = array_keys($summaryViewFieldsList);
		if(!is_array($params)){
			$params = array();
		}
		$params = array_merge($listHeaders,$params,$phoneNumberFields);
		//$params = array_merge($phoneNumberFields,$params);
		/*$refrenceUitypes = array(10,51,57,58,59,66,73,75,76,78,80,81,101);
		if(in_array($uitype,$refrenceUitypes)){
			$field_value = trim($field_value);
			$result = $adb->pquery("SELECT crmid FROM vtiger_crmentity WHERE label LIKE '%".$field_value."%' ");
			$numofrows = $adb->num_rows($result);
			for($i=0;$i<$numofrows;$i++){
				 $otherId[] = $adb->query_result($result,$i,'crmid');
			}
			$relation_name = $field_name;
			$field_value = implode(",",$otherId);
		}
		
		if($field_name == 'assigned_user_id'){
			$result = $adb->pquery("SELECT id FROM vtiger_users WHERE first_name LIKE '%".$field_value."%' OR last_name LIKE '%".$field_value."%' ");
			$numofrows = $adb->num_rows($result);
			for($i=0;$i<$numofrows;$i++){
				 $userId[] = $adb->query_result($result,$i,'id');
			}
			$field_name = '';
			$field_value = '';
		}*/
		$WithoutFilterModules = array('Users','CTUserFilterView');
		if(!$filterid && $module != ''  && !in_array($module, $WithoutFilterModules)) {
			if($searchwithor){
				$customView = new CustomView();
				$filterid = $customView->getViewIdByName('All', $module);
			}else{
				$customView = new CustomView();
				$filterid = $customView->getViewId($module);
			}
		}
		$filterOrAlertInstance = false;
		if(!empty($alertid)) {
			$filterOrAlertInstance = CTWhatsAppExt_WS_AlertModel::modelWithId($alertid);
		}
		else if(!empty($filterid)) {
			$filterOrAlertInstance = CTWhatsAppExt_WS_FilterModel::modelWithId($module, $filterid);
		}
		else if(!empty($search)) {
			
			$filterOrAlertInstance = $this->getSearchFilterModel($module, $search);
		}
		
		if($filterOrAlertInstance && strcmp($module, $filterOrAlertInstance->moduleName)) {
			$response = new CTWhatsAppExt_API_Response();
			$message = vtranslate('Mismatched module information.','CTWhatsAppExt');
			$response->setError(1001, $message);
			return $response;
		}
		

		// Initialize with more information
		if($filterOrAlertInstance) {
			$filterOrAlertInstance->setUser($current_user);
		}
		
		// Paging model
		$pagingModel = $this->getPagingModel($request);
		$paging = array('index'=>$index, 'size'=>$size);
		if($user_type == 'free'){
			$maxLimit = $index * $size;
			//~ if($maxLimit > 30){
				//~ $result = array();
				//~ $response = new CTWhatsAppExt_API_Response();
				//~ $msg = html_entity_decode('You do not have permission to view more records. Please subcscribe for Premium version.');
				//~ $response->setResult(array('records'=>$result,'msg'=>$msg,'module_record_status'=>false,'user_type'=>$user_type));
				//~ return $response;
			//~ }
		}
		/* Start: Added by Vijay Bhavsar */
		if($module == 'Leads') {
			$morefields = array('firstname', 'lastname', 'phone', 'company', 'designation', 'email', 'createdtime', 'modifiedtime','assigned_user_id');
			foreach ($params as $p) {
				if(!in_array($p, $morefields)){
					$morefields[]=$p;
				}
			}
		}else if($module == "Contacts"){
			$morefields = array('firstname', 'lastname', 'title', 'phone', 'email', 'createdtime', 'modifiedtime','assigned_user_id');
			foreach ($params as $p) {
				if(!in_array($p, $morefields)){
					$morefields[]=$p;
				}
			}
		}else if($module == "Products"){
			$morefields = array('productname','unit_price', 'createdtime', 'modifiedtime','assigned_user_id');
			foreach ($params as $p) {
				if(!in_array($p, $morefields)){
					$morefields[]=$p;
				}
			}
		}else if($module == "Services"){
			$morefields = array('servicename','unit_price', 'createdtime', 'modifiedtime','assigned_user_id');
			foreach ($params as $p) {
				if(!in_array($p, $morefields)){
					$morefields[]=$p;
				}
			}
		}else if($module == "CTUserFilterView"){
			$morefields = array('module_name','filter_id', 'filter_name','createdtime', 'modifiedtime', 'assigned_user_id');
			foreach ($params as $p) {
				if(!in_array($p, $morefields)){
					$morefields[]=$p;
				}
			}
		}else if($module == "Documents"){
			$morefields = array('notes_title', 'createdtime', 'modifiedtime','assigned_user_id');
			foreach ($params as $p) {
				if(!in_array($p, $morefields)){
					$morefields[]=$p;
				}
			}
		}else{
			$morefields = array();
			foreach ($params as $p) {
				$morefields[]=$p;
			}
			if($module == 'Users'){

			}else{
				$morefields[]= 'assigned_user_id';
			}
		}
		foreach($morefields as $key => $fields){
			if(!in_array($fields,$Modulefields)){
				unset($morefields[$key]);
			}else if($fieldModels[$fields]->isViewEnabled() != 1){
				unset($morefields[$key]);
			}
		}
		
		/* End: Added by Vijay Bhavsar */
		if($this->isCalendarModule($module)) {
			
			return $this->processSearchRecordLabelForCalendar($request, $filterOrAlertInstance, $pagingModel, $paging,$field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$related,$params,$getCount);
		}
		if($getCount != ''){
			$query = $this->fetchRecordLabelsForModule($module, $current_user, $morefields, $filterOrAlertInstance, $pagingModel, $paging, $field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$related,$discontinued,$getCount);
			$query1 = explode('FROM', $query);
			$totalQuery = "SELECT 1 FROM ".$query1[1];
			$response = new CTWhatsAppExt_API_Response();
			$totalResults = $adb->pquery($totalQuery,array());
			$totalRecords = $adb->num_rows($totalResults);
			$response->setResult(array('count'=>$totalRecords));
			return $response;
			exit;
		}else{
			$records = $this->fetchRecordLabelsForModule($module, $current_user, $morefields, $filterOrAlertInstance, $pagingModel, $paging, $field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$related,$discontinued,$getCount);
		}

		$modifiedRecords = array();
		foreach($records as $record) {
			if ($record instanceof SqlResultIteratorRow) {
				$record = $record->data;
				// Remove all integer indexed mappings
				for($index = count($record); $index > -1; --$index) {
					if(isset($record[$index])) {
						unset($record[$index]);
					}
				}
			}

			if($module == 'CTUserFilterView'){
				$total_records_count = 0;
				$user_id = '19x'.$current_user->id;
				if($user_id!=$record['assigned_user_id']){
					continue;
				}elseif($record['filter_id']!='' && $record['module_name']!='' && ctype_digit($record['filter_id'])){
					$listViewModel = Vtiger_ListView_Model::getInstance($record['module_name'], $record['filter_id']);
					$total_records_count = $listViewModel->getListViewCount();
			
				}
			}

			
			$recordid = $record['id'];
			unset($record['id']);
			
			$eventstart = '';
			if($this->isCalendarModule($module)) {
				$eventstart = $record['date_start'];
				unset($record['date_start']);
			}

			$values = array_values($record);
			if($module == 'Users') {
				//$label = implode(' ', $values);
				$label = $record['first_name'].' '.$record['last_name'];
			} else {
				$label = $values[1];
				$fieldnames = CTWhatsAppExt_WS_Utils::getEntityFieldnames($module);
				$label = $record[$fieldnames[0]];
			}
			
			

			$record_id = explode('x', $recordid);

			if($module != 'Users'){
				$delquery = "SELECT deleted FROM vtiger_crmentity WHERE deleted = '1' AND crmid = ?";
				$deletedResult = $adb->pquery($delquery,array($record_id[1]));
				if($adb->num_rows($deletedResult)){
					continue;
				}
			}
			$moduleModel = Vtiger_Module_Model::getInstance($module);
			$fieldModels = $moduleModel->getFields();
			$recordModel = Vtiger_Record_Model::getInstanceById($record_id[1],$module);
			foreach($record as $key => $value){
				if($value){
					if($key == 'hdngrandtotal'){
					$key = 'hdnGrandTotal';
				}
					$record[$key] = html_entity_decode($value, ENT_QUOTES, $default_charset);
					if(isset($record[$key])){
						$fieldModel = $fieldModels[$key];
						$uitype = $fieldModel->get('uitype');
						if($uitype != 53 && $uitype != 13 && $uitype != 17 && !in_array($uitype,$refrenceUitypes)){
							$record[$key] = $fieldModel->getDisplayValue($record[$key], $record_id[1], $recordModel);
						}
					}
				}else if($value == 0){
					$fieldModel = $fieldModels[$key];
					if($fieldModel){
						$uitype = $fieldModel->get('uitype');
						if($uitype != 53 && $uitype != 13 && $uitype != 17){
							$record[$key] = $fieldModel->getDisplayValue($record[$key], $record_id[1], $recordModel);
						}
					}
				}else{
					$record[$key] = "";
				}
				
			}
			/* Start: Added by Vijay Bhavsar */
			$query = "SELECT * FROM vtiger_smsnotifier_servers WHERE isactive='1'";
			$result = $adb->pquery($query,array());
			$totalRecords = $adb->num_rows($result);
			
			if($module == "Leads") {
				$modifiedRecord = array('id' => $recordid, 'label'=>$record['firstname']." ".$record['lastname'], 'firstname'=>$record['firstname'], 'lastname' => $record['lastname'], 'phone' => $record['phone'], 'company' => $record['company'], 'designation' => $record['designation'], 'email' => $record['email'], 'createdtime' => $record['createdtime'], 'modifiedtime'=>$record['modifiedtime'],'assigned_user_id'=>$record['assigned_user_id']); 
				foreach ($params as $p) {
					$uitype = $fieldModels[$p]->get('uitype');
					if($uitype == '11' && $record[$p] != ""){
						$modifiedRecord[$p]= $this->getMobileNumber($record[$p]);
					}else{
						$modifiedRecord[$p]=$record[$p];
					}
				}
				if($totalRecords > 0){
					$modifiedRecord['sms_notifier'] = true;
				}else{
					$modifiedRecord['sms_notifier'] = false;
				}
			} else if($module == "Contacts"){
				$record_id = explode('x', $recordid);
				$AttachmentQuery =$adb->pquery("select vtiger_attachments.attachmentsid, vtiger_attachments.name, vtiger_attachments.subject, vtiger_attachments.path, vtiger_attachments.storedname FROM vtiger_seattachmentsrel
											INNER JOIN vtiger_attachments ON vtiger_seattachmentsrel.attachmentsid = vtiger_attachments.attachmentsid 
											LEFT JOIN vtiger_notes ON vtiger_notes.notesid = vtiger_seattachmentsrel.crmid 
											WHERE vtiger_seattachmentsrel.crmid = ?", array($record_id[1]));
											
				$AttachmentQueryCount = $adb->num_rows($AttachmentQuery);
				$document_path = array();
				
				if($AttachmentQueryCount > 0) {
					$name = $adb->query_result($AttachmentQuery, 0, 'name');
					$Path = $adb->query_result($AttachmentQuery, 0, 'path');
					$storedName = $adb->query_result($AttachmentQuery, 0, 'storedname');
					$attachmentsId = $adb->query_result($AttachmentQuery, 0, 'attachmentsid');
					$contactImageUrl = $CRM_SITE_URL.$Path.$attachmentsId."_".$storedName;
				} else {
					$contactImageUrl = '';
				}
				$modifiedRecord = array('id' => $recordid, 'label'=>$record['firstname']." ".$record['lastname'], 'contactname' => $record['firstname']." ".$record['lastname'], 'title' => $record['title'], 'phoneNo'=> $record['phone'], 'email'=> $record['email'], 'contactimage' => $contactImageUrl, 'modifiedtime'=>$record['modifiedtime'], 'createdtime'=>$record['createdtime'],'assigned_user_id'=>$record['assigned_user_id']); 
				foreach ($params as $p) {
					$uitype = $fieldModels[$p]->get('uitype');
					if(in_array($uitype,$refrenceUitypes)){
						if($record[$p] == 0){
							$modifiedRecord[$p]="";
						}else{
							$labelresult = $adb->pquery("SELECT label FROM vtiger_crmentity WHERE crmid = ?",array($record[$p]));
							$new = $adb->query_result($labelresult,0,'label');
							$modifiedRecord[$p]=$new;
						}
					}else if($uitype == '11' && $record[$p] != ""){
						$modifiedRecord[$p]= $this->getMobileNumber($record[$p]);
					}else{
						$modifiedRecord[$p]=$record[$p];
				    }
				}
				if($totalRecords > 0){
					$modifiedRecord['sms_notifier'] = true;
				}else{
					$modifiedRecord['sms_notifier'] = false;
				}
			}else if($module == "Products") {
				$record_id = explode('x', $recordid);
				$AttachmentQuery =$adb->pquery("select vtiger_attachments.attachmentsid, vtiger_attachments.name, vtiger_attachments.subject, vtiger_attachments.path, vtiger_attachments.storedname FROM vtiger_seattachmentsrel
											INNER JOIN vtiger_attachments ON vtiger_seattachmentsrel.attachmentsid = vtiger_attachments.attachmentsid 
											LEFT JOIN vtiger_notes ON vtiger_notes.notesid = vtiger_seattachmentsrel.crmid 
											WHERE vtiger_seattachmentsrel.crmid = ?", array($record_id[1]));
											
				$AttachmentQueryCount = $adb->num_rows($AttachmentQuery);
				$document_path = array();
				
				if($AttachmentQueryCount > 0) {
					$name = $adb->query_result($AttachmentQuery, 0, 'name');
					$Path = $adb->query_result($AttachmentQuery, 0, 'path');
					$storedName = $adb->query_result($AttachmentQuery, 0, 'storedname');
					$attachmentsId = $adb->query_result($AttachmentQuery, 0, 'attachmentsid');
					$productImageUrl = $CRM_SITE_URL.$Path.$attachmentsId."_".$storedName;
				} else {
					$productImageUrl = '';
				}
				$modifiedRecord = array('id' => $recordid, 'label'=>$record['productname'], 'productimage' => $productImageUrl,'unit_price' => number_format((float)$record['unit_price'], 2, '.', ''), 'createdtime' => $record['createdtime'], 'modifiedtime'=>$record['modifiedtime'],'assigned_user_id'=>$record['assigned_user_id']);
				foreach ($params as $p) {
					$uitype = $fieldModels[$p]->get('uitype');
					if(in_array($uitype,$refrenceUitypes)){
						if($record[$p] == 0){
							$modifiedRecord[$p]="";
						}else{
							$labelresult = $adb->pquery("SELECT label FROM vtiger_crmentity WHERE crmid = ?",array($record[$p]));
							$new = $adb->query_result($labelresult,0,'label');
							$modifiedRecord[$p]=$new;
						}
					}else{
						$modifiedRecord[$p]=$record[$p];
				    }
				} 
			}else if($module == "Services") {
				$modifiedRecord = array('id' => $recordid, 'label'=>$record['servicename'], 'unit_price' => number_format((float)$record['unit_price'], 2, '.', ''), 'createdtime' => $record['createdtime'], 'modifiedtime'=>$record['modifiedtime'],'assigned_user_id'=>$record['assigned_user_id']); 
				foreach ($params as $p) {
					$uitype = $fieldModels[$p]->get('uitype');
					if(in_array($uitype,$refrenceUitypes)){
						if($record[$p] == 0){
							$modifiedRecord[$p]="";
						}else{
							$labelresult = $adb->pquery("SELECT label FROM vtiger_crmentity WHERE crmid = ?",array($record[$p]));
							$new = $adb->query_result($labelresult,0,'label');
							$modifiedRecord[$p]=$new;
						}
					}else{
						$modifiedRecord[$p]=$record[$p];
				    }
				}
			}else if($module == "CTUserFilterView") {
				$modifiedRecord = array('id' => $recordid, 'label'=>$label, 'module_name'=>$record['module_name'], 'filter_id'=>$record['filter_id'], 'filter_name'=>$record['filter_name'],'modifiedtime'=>$record['modifiedtime'],'total_records_count'=>$total_records_count,'assigned_user_id'=>$record['assigned_user_id']); 
				foreach ($params as $p) {
					$uitype = $fieldModels[$p]->get('uitype');
					if(in_array($uitype,$refrenceUitypes)){
						if($record[$p] == 0){
							$modifiedRecord[$p]="";
						}else{
							$labelresult = $adb->pquery("SELECT label FROM vtiger_crmentity WHERE crmid = ?",array($record[$p]));
							$new = $adb->query_result($labelresult,0,'label');
							$modifiedRecord[$p]=$new;
						}
					}else{
						$modifiedRecord[$p]=$record[$p];
				    }
				}
			}else if($module == "Documents") {
				$modifiedRecord = array('id' => $recordid, 'label'=>$record['notes_title'], 'modifiedtime'=>$record['modifiedtime'],'assigned_user_id'=>$record['assigned_user_id']); 
				foreach ($params as $p) {
					$uitype = $fieldModels[$p]->get('uitype');
					if(in_array($uitype,$refrenceUitypes)){
						if($record[$p] == 0){
							$modifiedRecord[$p]="";
						}else{
							$labelresult = $adb->pquery("SELECT label FROM vtiger_crmentity WHERE crmid = ?",array($record[$p]));
							$new = $adb->query_result($labelresult,0,'label');
							$modifiedRecord[$p]=$new;
						}
					}else{
						$modifiedRecord[$p]=$record[$p];
				    }
				}
			}else {
				$modifiedRecord = array('id' => $recordid,'label'=>$label);
				foreach ($params as $p) {
					$uitype = $fieldModels[$p]->get('uitype');
					if(in_array($uitype,$refrenceUitypes)){
						if($record[$p] == 0){
							$modifiedRecord[$p]="";
						}else{
							$labelresult = $adb->pquery("SELECT label FROM vtiger_crmentity WHERE crmid = ?",array($record[$p]));
							$new = $adb->query_result($labelresult,0,'label');
							$modifiedRecord[$p]=$new;
						}
					}else if($uitype == '11' && $record[$p] != ""){
						$modifiedRecord[$p]= $this->getMobileNumber($record[$p]);
					}else{
						$modifiedRecord[$p]=$record[$p];
				    }
				    $modifiedRecord[$p];
				}
				 $modifiedRecord['modifiedtime'] = $record['modifiedtime'];
				 $modifiedRecord['assigned_user_id'] = $record['assigned_user_id'];
			}
			
			/* End: Added by Vijay Bhavsar */
			
			//get Username Form userid
			if(!empty($modifiedRecord['assigned_user_id'])){
				if($module == 'CTUserFilterView'){
					$modifiedRecord['assigned_user_id'] = explode('x',$modifiedRecord['assigned_user_id']);
					$modifiedRecord['assigned_user_id'] = $modifiedRecord['assigned_user_id'][1];
				}
				$userRecordModel = Vtiger_Record_Model::getInstanceById($modifiedRecord['assigned_user_id'],'Users');
				if(empty($userRecordModel->get('user_name'))){
					$query = "SELECT groupname FROM vtiger_groups WHERE groupid = ?";
					$groupResults = $adb->pquery($query,array($modifiedRecord['assigned_user_id']));
					$modifiedRecord['assigned_user_id'] = $adb->query_result($groupResults,0,'groupname');
				}else{
					$modifiedRecord['assigned_user_id'] = $userRecordModel->get('first_name').' '.$userRecordModel->get('last_name');
				}	
			}
			
			if(!empty($eventstart)) {
				$modifiedRecord['eventstart'] = $eventstart;
			}
			if(!empty($userId)){
				if(in_array($modifiedRecord['assigned_user_id'],$userId)){
					$modifiedRecords[] = $modifiedRecord;
				}else{
					continue;
				}
			}else{
				$modifiedRecords[] = $modifiedRecord;
			}	
			
		}
		
		
		foreach ($modifiedRecords as $key => $part) {
			if($module != 'Users'){
				$ids = explode('x',$part['id']);
				$record__id = $ids[1];
				$recordModell = Vtiger_Record_Model::getInstanceById($record__id,$module);
				$modifiedRecords[$key]['detailURL'] = $CRM_SITE_URL.$recordModell->getDetailViewUrl();
			}else{
				$ids = explode('x',$part['id']);
				$userid = $ids[1];
				$modifiedRecords[$key]['UserImage'] = CTWhatsAppExt_WS_Utils::getUserImage($userid);
			}
			foreach($part as $keys => $value){
				if(!in_array($keys,$morefields) && !in_array($keys,array('label','id','sms_notifier','total_records_count','contactimage','productimage'))){
					unset($modifiedRecords[$key][$keys]);
				}
			}
			$sort[$key] = strtotime($part['modifiedtime']);	
		}

		$USER_MODEL = Users_Record_Model::getCurrentUserModel();
		$AccessibleUsers = array_keys($USER_MODEL->getAccessibleUsers());

		$AllowedUsers = array();
		foreach ($modifiedRecords as $key => $part) {
			if($module == 'Users' && $type == 'owner'){
				$id = explode('x', $part['id']);
				$userid = $id[1];
				if(!in_array($userid, $AccessibleUsers)){
					unset($modifiedRecords[$key]);
				}else{
					$AllowedUsers[] = $modifiedRecords[$key];
				}
			}else if($module == 'Users' && $isMentionUser == true){
				$id = explode('x', $part['id']);
				$userid = $id[1];
				if(!in_array($userid, $AccessibleUsers)){
					unset($modifiedRecords[$key]);
				}else{
					$AllowedUsers[] = $modifiedRecords[$key];
				}
			}	
			$sort[$key] = strtotime($part['modifiedtime']);	
		}
		
		if($module == 'Users' && $type == 'owner'){
			$users = $AllowedUsers;
			$pagingModel = $this->getPagingModel($request);
			$paging = array('index'=>$index, 'size'=>$size);
			$modifiedRecords = array();
			$modifiedRecords = $this->GroupDetails($pagingModel,$paging);
			$groups = $modifiedRecords;
			$modifiedRecord = array();
			$modifiedRecord['Users'] = $users;
			$modifiedRecord['Groups'] = $groups;
			$moduleLabel = vtranslate($module,$module);
			$response = new CTWhatsAppExt_API_Response();
			$response->setResult(array('records'=>$modifiedRecord, 'module'=>$module,'moduleLabel'=>$moduleLabel, 'message'=>'','module_record_status'=>true));
			return $response;
		}

		if($this->totalQuery != ""){
			$totalResults = $adb->pquery($this->totalQuery,$this->totalParams);
			$totalRecords = $adb->num_rows($totalResults);
			$totalpage = ceil($totalRecords / $paging['size']);
			if($paging['index'] && $paging['size']){
				if($totalRecords > $paging['index']*$paging['size']){
					$isLast = false;	
					$pagesize = $paging['index']-1;
					$startRange = $pagesize*$paging['size']+1;
					$lastRange = $paging['index']*$paging['size'];	
				}else{
					$isLast = true;
					$pagesize = $paging['index']-1;
					$startRange = $pagesize*$paging['size']+1;
					$lastRange = $totalRecords;
				}
			}else{
				$isLast = true;
				$startRange = 1;
				$lastRange = $totalRecords;
			}

			$totalLabel = $startRange.' '.vtranslate('LBL_to', $module).' '.$lastRange.' '.vtranslate('LBL_OF', $module).' '.$totalRecords;
			
		}

		//for create action 
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		$createAction = $userPrivModel->hasModuleActionPermission($moduleModel->getId(), 'CreateView');
		
		$moduleLabel = vtranslate($module,$module);
		$response = new CTWhatsAppExt_API_Response();
		if(count($modifiedRecords) == 0) {
			$response->setResult(array('records'=>$modifiedRecords, 'module'=>$module,'moduleLabel'=>$moduleLabel, 'message'=>vtranslate('LBL_NO_RECORDS_FOUND','Vtiger'),'module_record_status'=>false,'createAction'=>$createAction,'entity_key'=>$entity_key));
		} else {
			$response->setResult(array('records'=>$modifiedRecords, 'module'=>$module,'moduleLabel'=>$moduleLabel, 'message'=>'','module_record_status'=>true,'createAction'=>$createAction,'entity_key'=>$entity_key,'pagingLabel'=>$totalLabel,'totalRecords'=>$totalRecords,'totalpage'=>$totalpage));
		}
		
		return $response;
	}
	
	function processSearchRecordLabelForCalendar(CTWhatsAppExt_API_Request $request,$filterOrAlertInstance = false, $pagingModel = false, $paging = array(),$field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$related,$params,$getCount) {
		$current_user = $this->getActiveUser();
		$module = $request->get('module');
		// Fetch both Calendar (Todo) and Event information
		$moreMetaFields = array('date_start', 'time_start', 'activitytype', 'location', 'subject', 'createdtime');
		foreach($params as $p){
			if(!in_array($p,$moreMetaFields)){
				$moreMetaFields[] = $p;
			}
		}
		$discontinued = 0;
		$records=$this->fetchRecordLabelsForModule($module, $current_user, $moreMetaFields, $filterOrAlertInstance, $pagingModel, $paging,$field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$related,$discontinued,$getCount);

		$modifiedRecords = array();
		foreach($records as $record) {
			if ($record instanceof SqlResultIteratorRow) {
				$record = $record->data;
				// Remove all integer indexed mappings
				for($index = count($record); $index > -1; --$index) {
					if(isset($record[$index])) {
						unset($record[$index]);
					}
				}
			}
		    $recordId = explode('x',$record['id']);
		    global $adb;
		    $modifiedRecord = array();
		    $EventTaskQuery = $adb->pquery("SELECT * FROM  `vtiger_activity` WHERE activitytype = ? AND activityid = ?",array('Task',$recordId[1])); 
		    if($adb->num_rows($EventTaskQuery) > 0){
				$wsid = CTWhatsAppExt_WS_Utils::getEntityModuleWSId('Calendar');
				$record['id'] = $wsid.'x'.$recordId[1];
				$modifiedRecord['module'] = 'Calendar';
			}else{
				$wsid = CTWhatsAppExt_WS_Utils::getEntityModuleWSId('Events');
				$record['id'] = $wsid.'x'.$recordId[1];
				$modifiedRecord['module'] = 'Events';
			}
			$refrenceUitypes = array(10,51,57,58,59,66,73,75,76,78,80,81,101);
			$moduleModel = Vtiger_Module_Model::getInstance($module);
			$fieldModels = $moduleModel->getFields();
			$modifiedRecord['id'] = $record['id'];                      
			unset($record['id']);
			foreach($moreMetaFields as $fields){
				$uitype = $fieldModels[$fields]->get('uitype');
				if(in_array($uitype,$refrenceUitypes)){
					if($record[$p] == 0){
						$modifiedRecord[$fields]="";
					}else{
						$labelresult = $adb->pquery("SELECT label FROM vtiger_crmentity WHERE crmid = ?",array($record[$fields]));
						$new = $adb->query_result($labelresult,0,'label');
						$modifiedRecord[$fields]=$new;
					}
				}else if($fields == 'assigned_user_id'){
					$userRecordModel = Vtiger_Record_Model::getInstanceById($record['assigned_user_id'],'Users');
					if(empty($userRecordModel->get('user_name'))){
						$query = "SELECT groupname FROM vtiger_groups WHERE groupid = ?";
						$groupResults = $adb->pquery($query,array($modifiedRecord['assigned_user_id']));
						$modifiedRecord['assigned_user_id'] = $adb->query_result($groupResults,0,'groupname');
					}else{
						$modifiedRecord['assigned_user_id'] = $userRecordModel->get('first_name').' '.$userRecordModel->get('last_name');
					}
				}else{
					$recordModel = Vtiger_Record_Model::getInstanceById($recordId[1],'Calendar');
					if(!empty($record[$fields])){
						$modifiedRecord[$fields] = $fieldModels[$fields]->getDisplayValue($record[$fields], $recordId[1], $recordModel);
					}else{
						$modifiedRecord[$fields] = "";
					}
  
				}
				unset($record[$fields]);
			}
			
			$modifiedRecord['label'] =  $modifiedRecord['subject'];
			$modifiedRecord['startDateTime'] = $modifiedRecord['eventstartdate']." ".$modifiedRecord['eventstarttime'];
			if(Users_Privileges_Model::isPermitted($module, 'DetailView', $recordId[1])){
				$modifiedRecords[] = $modifiedRecord;
			}
		}
		
		foreach ($modifiedRecords as $key => $part) {
			$sort[$key] = strtotime($part['startDateTime']);
		}
		array_multisort($sort, SORT_DESC, $modifiedRecords);
		$moduleLabel = vtranslate($module,$module);
		$response = new CTWhatsAppExt_API_Response();
		if(count($modifiedRecords) == 0) {
			$response->setResult(array('records'=>$modifiedRecords, 'module'=>$module,'moduleLabel'=>$moduleLabel, 'message'=>vtranslate('LBL_NO_RECORDS_FOUND','Vtiger'),'module_record_status'=>false));
		} else {
			$response->setResult(array('records'=>$modifiedRecords, 'module'=>$module,'moduleLabel'=>$moduleLabel, 'message'=>'','module_record_status'=>true));
		}
		
		return $response;
	}
	
	function fetchRecordLabelsForModule($module, $user, $morefields=array(), $filterOrAlertInstance=false, $pagingModel = false, $paging=array(), $field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$related,$discontinued,$getCount) {
		
		if($module != 'Users') {
			$morefields[]='modifiedtime';
		}
		
		if($this->isCalendarModule($module)) {
			$fieldnames = CTWhatsAppExt_WS_Utils::getEntityFieldnames('Calendar');
		} else {
			$fieldnames = CTWhatsAppExt_WS_Utils::getEntityFieldnames($module);
		}
		
		if(!empty($morefields)) {
			foreach($morefields as $fieldname) $fieldnames[] = $fieldname;
		}

		if($filterOrAlertInstance === false) {
			$filterOrAlertInstance = CTWhatsAppExt_WS_SearchFilterModel::modelWithCriterias($module);
			$filterOrAlertInstance->setUser($user);
		}
			
		return $this->queryToSelectFilteredRecords($module, $fieldnames, $filterOrAlertInstance, $pagingModel, $paging, $field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$user,$related,$discontinued,$getCount);
	}
	
	function queryToSelectFilteredRecords($module, $fieldnames, $filterOrAlertInstance, $pagingModel, $paging = array(), $field_name, $field_value,$field_compare,$searchwithor,$order_by,$orderby,$user,$related,$discontinued,$getCount) {
		if (($filterOrAlertInstance instanceof CTWhatsAppExt_WS_SearchFilterModel) && !$this->isCalendarModule($module)) {
			if(!empty($order_by) && !empty($orderby)){
				$orderClause = " ORDER BY ".$order_by." ".$orderby;
			}else{
				$orderClause = '';
			}
			return $filterOrAlertInstance->execute($fieldnames, $pagingModel, $paging, $orderClause,$field_name,$field_value);
			
		}
		if($field_name){
			$fieldnames = array_merge($fieldnames,Zend_JSON::decode($field_name));
		}
		
		global $adb;
		$moduleWSId = CTWhatsAppExt_WS_Utils::getEntityModuleWSId($module);
		$columnByFieldNames = CTWhatsAppExt_WS_Utils::getModuleColumnTableByFieldNames($module, $fieldnames);
		// Build select clause similar to Webservice query
		$selectColumnClause = "CONCAT('{$moduleWSId}','x',vtiger_crmentity.crmid) as id,";
		foreach($columnByFieldNames as $fieldname=>$fieldinfo) {
			$selectColumnClause .= sprintf("%s.%s as %s,", $fieldinfo['table'],$fieldinfo['column'],$fieldname);
		}
		
		$selectColumnClause = rtrim($selectColumnClause, ',');
		$var =array();
		for($i=0;$i<count($fieldnames);$i++){
			$var[]= $fieldnames[$i];
		}
		$var[]='id';
		$generator = new QueryGenerator($module, $user);
		if($related != 1){
		 $generator->initForCustomViewById($filterOrAlertInstance->filterid);
	    }
		$generator->setFields($var);
		$query = $generator->getQuery();
		$query = preg_replace("/SELECT.*FROM(.*)/i", "SELECT $selectColumnClause FROM $1", $query);
		if($module == 'Events' || $module == 'Calendar'){
			$Eventsquery = explode('WHERE',$query);
			$query = $Eventsquery[0]." WHERE vtiger_crmentity.setype = 'Calendar' AND ".$Eventsquery[1];
		}else if($module == 'Products' && $discontinued == 1){
			$Productsquery = explode('WHERE',$query);
			$query = $Productsquery[0]." WHERE vtiger_products.discontinued = 1 AND ".$Productsquery[1];
		}else if($module == 'Services' && $discontinued == 1){
			$Servicesquery = explode('WHERE',$query);
			$query = $Servicesquery[0]." WHERE vtiger_service.discontinued = 1 AND ".$Servicesquery[1];
		}

		$moduleModel = Vtiger_Module_Model::getInstance($module);
		$fieldModels = $moduleModel->getFields();

		$fieldcount = 1;
		if($field_name && $field_value){
			$field_names = Zend_JSON::decode($field_name);
			$field_values = Zend_JSON::decode($field_value);
			$field_compares = Zend_JSON::decode($field_compare);
			if($module == 'Contacts' && $field_names[0] == 'firstname' && $field_names[1] == 'lastname' && $field_values[0] == $field_values[1]){
				if($field_compares[0] == 'LIKE'){
					$tablename =  $fieldModels['firstname']->get('table');
					$query .= " AND CONCAT_WS(' ',".$tablename.".firstname,".$tablename.".lastname) LIKE '%".$field_values[0]."%'";
				}else{
					$tablename =  $fieldModels['firstname']->get('table');
					$query .= " AND CONCAT_WS(' ',".$tablename.".firstname,".$tablename.".lastname) = '".$field_values[0]."'";
				}
			}else if($module == 'Leads' && $field_names[0] == 'firstname' && $field_names[1] == 'lastname' && $field_values[0] == $field_values[1]){
				if($field_compares[0] == 'LIKE'){
					$tablename =  $fieldModels['firstname']->get('table');
					$query .= " AND CONCAT_WS(' ',".$tablename.".firstname,".$tablename.".lastname) LIKE '%".$field_values[0]."%'";
				}else{
					$tablename =  $fieldModels['firstname']->get('table');
					$query .= " AND CONCAT_WS(' ',".$tablename.".firstname,".$tablename.".lastname) = '".$field_values[0]."'";
				}
			}else{
				//print_r($field_values);
				if(!empty($field_names) && $searchwithor){
					$query.= " AND ( ";
				}
				foreach ($field_names as $key => $field_name) {
					$field_value = addslashes(trim($field_values[$key]));
					$fieldcompare = $field_compares[$key];
					$tablename = $columnByFieldNames[$field_name]['table'];
					if($field_name){
						$uitype = $fieldModels[$field_name]->get('uitype');
						$typeofdata = explode('~',$fieldModels[$field_name]->get('typeofdata'));
					}

					$refrenceUitypes = array(10,51,57,58,59,66,73,75,76,77,78,80,81,101);
					if($module == 'Documents' && $fieldname == 'folderid'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$fieldValue[1]."%'";
						}else{
							$comparestring = "= '".$fieldValue[1]."'";
						}
						if($searchwithor && $fieldcount != 1){
							$query .= " OR ".$tablename.".".$column." $comparestring";
						}else if($fieldcount == 1 && $searchwithor){
							$query .= "  ".$tablename.".".$column." $comparestring";
						}else{
							$query .= " AND ".$tablename.".".$column." $comparestring";
						}
					}else if($module == 'PriceBooks' && $fieldname == 'currency_id'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$fieldValue[1]."%'";
						}else{
							$comparestring = "= '".$fieldValue[1]."'";
						}
						if($searchwithor && $fieldcount != 1){
							$query .= " OR ".$tablename.".".$column." $comparestring";
						}else if($fieldcount == 1 && $searchwithor){
							$query .= "  ".$tablename.".".$column." $comparestring";
						}else{
							$query .= " AND ".$tablename.".".$column." $comparestring";
						}
					}else if(in_array($uitype,$refrenceUitypes)){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$fieldValue[1]."%'";
						}else{
							$comparestring = "= '".$fieldValue[1]."'";
						}
						if($searchwithor && $fieldcount != 1){
							$query .= " OR ".$tablename.".".$column." $comparestring";
						}else if($fieldcount == 1 && $searchwithor){
							$query .= "  ".$tablename.".".$column." $comparestring";
						}else{
							$query .= " AND ".$tablename.".".$column." $comparestring";
						}
					}else if($field_name == 'assigned_user_id'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode('x',$field_value);
						if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$fieldValue[1]."%'";
						}else{
							$comparestring = "= '".$fieldValue[1]."'";
						}
						if($searchwithor && $fieldcount != 1){
							$query .= " OR ".$tablename.".".$column." $comparestring";
						}else if($fieldcount == 1 && $searchwithor){
							$query .= "  ".$tablename.".".$column." $comparestring";
						}else{
							$query .= " AND ".$tablename.".".$column." $comparestring";
						}
					}else if($uitype == 33){
						$fieldvalues = explode(',', $field_value);
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						if($searchwithor && $fieldcount != 1){
							$query.= " OR (( ";
						}else if($fieldcount == 1 && $searchwithor){
							$query.= "  (( ";
						}else{
							$query.= " AND (( ";
						}
						//echo "<pre>";print_r($fieldvalues);
						/*if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$fieldValue."%'";
						}else{
							$comparestring = "= '".$fieldValue."'";
						}*/
						foreach ($fieldvalues as $key => $fieldValue) {
							if($fieldcompare == 'LIKE'){
								$comparestring = "LIKE '%".$fieldValue."%'";
							}else{
								$comparestring = "= '".$fieldValue."'";
							}//end of else

							if($key+1 == count($fieldvalues)){
								$query.= " ".$tablename.".".$column." $comparestring ";
							}else{
								$query.= " ".$tablename.".".$column." $comparestring OR ";
							}
						}
						$query.= " )) ";					
					}else if(in_array($uitype, array(5,6,23,70))){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValue = explode(",",$field_value);
						if($uitype == 70){
							$date1 = Vtiger_Datetime_UIType::getDBDateTimeValue($fieldValue[0].' 00:00:01');
							$date2 = Vtiger_Datetime_UIType::getDBDateTimeValue($fieldValue[1].' 23:59:00');
							if($searchwithor && $fieldcount != 1){
								$query.= " OR ".$tablename.".".$column." BETWEEN '".$date1."' AND '".$date2."'";
							}else if($fieldcount == 1 && $searchwithor){
								$query .= "  ".$tablename.".".$column." BETWEEN '".$date1."' AND '".$date2."'";
							}else{
								$query.= " AND ".$tablename.".".$column." BETWEEN '".$date1."' AND '".$date2."'";
							}
						}else{
							if(count($fieldValue) > 1){
								$date1 = $nowInDBFormat = Vtiger_Date_UIType::getDBInsertedValue($fieldValue[0]);
								$date2 = $nowInDBFormat = Vtiger_Date_UIType::getDBInsertedValue($fieldValue[1]);
								if($searchwithor && $fieldcount != 1){
									$query.= " OR DATE(".$tablename.".".$column.") BETWEEN '".$date1."' AND '".$date2."'";
								}else if($fieldcount == 1 && $searchwithor){
									$query .= "  DATE(".$tablename.".".$column.") BETWEEN '".$date1."' AND '".$date2."'";
								}else{
									$query.= " AND DATE(".$tablename.".".$column.") BETWEEN '".$date1."' AND '".$date2."'";
								}
							}else{
								$date1 = $nowInDBFormat = Vtiger_Date_UIType::getDBInsertedValue($field_value);
								if($searchwithor && $fieldcount != 1){
									$query.= " OR DATE(".$tablename.".".$column.") = '".$date1."'";
								}else if($fieldcount == 1 && $searchwithor){
									$query .= "  DATE(".$tablename.".".$column.") = '".$date1."'";
								}else{
									$query.= " AND DATE(".$tablename.".".$column.") = '".$date1."'";
								}
							}
						}
						
					}else if($typeofdata[0] == 'T'){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						if($module == 'Calendar' || $module == 'Events'){
							$date = Vtiger_Date_UIType::getDisplayDateValue(date('Y-m-d'));
							$nowInUserFormat = $date.' '.$field_value;
							$nowInDBFormat = Vtiger_Datetime_UIType::getDBDateTimeValue($nowInUserFormat);
							$dateTime = explode(' ',$nowInDBFormat);
							if($fieldcompare == 'LIKE'){
								$comparestring = "LIKE '%".$dateTime[1]."%'";
							}else{
								$comparestring = "= '".$dateTime[1]."'";
							}
							if($searchwithor){
								$query.= " OR ".$tablename.".".$column." $comparestring";
							}else{
								$query.= " AND ".$tablename.".".$column." $comparestring";
							}
						}else{
							$dateTime =  Vtiger_Time_UIType::getTimeValueWithSeconds($field_value);
							if($searchwithor && $fieldcount != 1){
								$query.= " OR ".$tablename.".".$column." = '".$dateTime."'";
							}else if($fieldcount == 1 && $searchwithor){
								$query .= "  ".$tablename.".".$column." = '".$dateTime."'";
							}else{
								$query.= " AND ".$tablename.".".$column." = '".$dateTime."'";
							}
						}
					}else if(in_array($uitype, array(71,72))){
						$cureeModel = $fieldModels[$field_name];
						$field_value = $cureeModel->getDBInsertValue($field_value);
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$field_value."%'";
						}else{
							$comparestring = "= '".$field_value."'";
						}
						if($searchwithor && $fieldcount != 1){
							$query .= " OR ".$tablename.".".$column." $comparestring";
						}else if($fieldcount == 1 && $searchwithor){
							$query .= "  ".$tablename.".".$column." $comparestring";
						}else{
							$query .= " AND ".$tablename.".".$column." $comparestring";
						}
					}else if($uitype == 117){
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						$fieldValuee = explode('x', $field_value);
						if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$fieldValuee[1]."%'";
						}else{
							$comparestring = "= '".$fieldValuee[1]."'";
						}
						if($searchwithor && $fieldcount != 1){
							$query .= " OR ".$tablename.".".$column." $comparestring";
						}else if($fieldcount == 1 && $searchwithor){
							$query .= "  ".$tablename.".".$column." $comparestring";
						}else{
							$query .= " AND ".$tablename.".".$column." $comparestring";
						}
					}else if($field_name == 'taskstatus' || $field_name == 'taskstatus'){
						if($fieldcompare == 'LIKE'){
							$comparestring = "LIKE '%".$field_value."%'";
						}else{
							$comparestring = "= '".$field_value."'";
						}
						if($searchwithor && $fieldcount != 1){
							$query .= " OR ((vtiger_activity.status $comparestring ) OR (vtiger_activity.eventstatus  $comparestring )) ";
						}else if($fieldcount == 1 && $searchwithor){
							$query .= "  ((vtiger_activity.status $comparestring ) OR (vtiger_activity.eventstatus $comparestring )) ";
						}else{
							$query .= " AND ((vtiger_activity.status $comparestring ) OR (vtiger_activity.eventstatus $comparestring )) ";
						}
					}else{
						$tablename =  $fieldModels[$field_name]->get('table');
						$column =  $fieldModels[$field_name]->get('column');
						if($field_name2 != '' && $field_value2 != ''){
							if($searchwithor){
								$query .= " OR ".$tablename.".".$column." = '".$field_value."'";
							}else{
								$query .= " AND ".$tablename.".".$column." = '".$field_value."'";
							}
						}else{
							if($fieldcompare == 'LIKE'){
								$comparestring = "LIKE '%".$field_value."%'";
							}else{
								$comparestring = "= '".$field_value."'";
							}
							if($searchType != '' && $searchType == 'barcode'){
								if($searchwithor && $fieldcount != 1){
									$query .= " OR ".$tablename.".".$column." $comparestring";
								}else if($fieldcount == 1 && $searchwithor){
									$query .= "  ".$tablename.".".$column." $comparestring";
								}else{
									$query .= " AND ".$tablename.".".$column." $comparestring";
								}
							}else{
								if($searchwithor && $fieldcount != 1){
									$query .= " OR ".$tablename.".".$column." $comparestring";
								}else if($fieldcount == 1 && $searchwithor){
									$query .= "  ".$tablename.".".$column." $comparestring";
								}else{
									$query .= " AND ".$tablename.".".$column." $comparestring";
								}
							}
						}
					}
				$fieldcount++;
				}

				if(!empty($field_names) && $searchwithor){
					$query.= " ) ";
				}
			}
		}
			
		if($pagingModel !== false) {
			$index = $paging['index'];
			$size = $paging['size'];
			$limit = ($index*$size) - $size;
			if($index != '' && $size != '') {
				if($order_by){
					if($module == 'Calendar'){
						$query.= ' GROUP BY vtiger_activity.activityid ';
					}
					$moduleModel = Vtiger_Module_Model::getInstance($module);
					$fieldModels = $moduleModel->getFields();
					$tablename =  $fieldModels[$order_by]->get('table');
					$column =  $fieldModels[$order_by]->get('column');
				   if($orderby){
					   	if($order_by == 'date_start') {
				            $query .= " ORDER BY str_to_date(concat(date_start,time_start),'%Y-%m-%d %H:%i:%s') $orderby ";
				        } else if($order_by == 'due_date') {
				            $query .= " ORDER BY str_to_date(concat(due_date,time_end),'%Y-%m-%d %H:%i:%s') $orderby ";
				        } else {
							$query .= " ORDER BY $tablename.$column $orderby ";
						}
				   }else{
						$query .= " ORDER BY $tablename.$column ASC ";
				   }	
				}else{
				   $query .= " ORDER BY vtiger_crmentity.modifiedtime DESC";
				}
				$this->totalQuery = $query;
				$this->totalParams = $filterOrAlertInstance->queryParameters();
				$query .= sprintf(" LIMIT %s, %s", $limit, $size);
			}
		}else{
			if($module == 'Users'){
				$query.= " ORDER BY firstname ASC ";
			}
			$this->totalQuery = $query;
			$totalquery1 = explode('FROM',$this->totalQuery);
			$this->totalQuery = "SELECT 1 FROM ".$totalquery1[1];
			$this->totalParams = $filterOrAlertInstance->queryParameters();
		}
		//~ if($module == 'Leads'){
			//~ if (strpos($query, 'INNER JOIN vtiger_leadaddress') == false) {
				//~ $query_explode = explode('WHERE',$query);
				//~ $query = $query_explode[0]." INNER JOIN vtiger_leadaddress ON vtiger_leadaddress.leadaddressid = vtiger_crmentity.crmid WHERE ".$query_explode[1]." AND ".$field_name." LIKE %".$field_value."%";
			//~ }	
		//~ }
		if($_REQUEST['getCount']){
			return $query;
		}else{
			$prequeryResult = $adb->pquery($query, $filterOrAlertInstance->queryParameters());
			return new SqlResultIterator($adb, $prequeryResult);
		}
	}

	public function getMobileNumber($mobileno){
		global $adb;
		$getCountrycodeQuery = $adb->pquery("SELECT * FROM ctwhatsappext_countrycode_settings");
		$country_code = $adb->query_result($getCountrycodeQuery, 0, 'country_code');

		//$mobileno = preg_replace('/[^A-Za-z0-9\-]/', '', $mobileno);
		$pattern = '/[\s\(\)\+\-]/';

    	// Use preg_replace() function to replace all occurrences of the pattern with an empty string
    	$mobileno = preg_replace($pattern, '', $mobileno);
		$mobilenoLen = strlen($mobileno);

		//Get Max. Phone Number Digit
		$getMaxNumberDigitData = $adb->pquery("SELECT * FROM ctwhatsappext_phonenumberdigit_settings");
		$numOfNumberDigit = $adb->num_rows($getMaxNumberDigitData);

        if($numOfNumberDigit > 0){
			$maxNumberDigit = $adb->query_result($getMaxNumberDigitData, 0, 'max_number_digit');
		}//end of if

		if($maxNumberDigit == ''){
			$maxNumberDigit = 10;
		}//end of if

		if($mobilenoLen > $maxNumberDigit && $country_code != ''){
			$withoutcode = substr($mobileno, -$maxNumberDigit);
			$mobileno = $country_code.$withoutcode;
		}else if($country_code != ''){
			$mobileno = $country_code.$mobileno;
		}else{
			$mobileno = $mobileno;
		}
		return $mobileno;
	}
	
}


