<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTWhatsAppExt_WS_Login extends CTWhatsAppExt_WS_Controller {

	function requireLogin() {
		return false;
	}

	function process(CTWhatsAppExt_API_Request $request) {
		global $adb, $site_URL;
		$response = new CTWhatsAppExt_API_Response();

		$username = trim($request->get('username'));
		$password = trim($request->get('password'));

		$current_user = CRMEntity::getInstance('Users');
		$current_user->column_fields['user_name'] = $username;

		
		$Inactiveuser = false;
		if(!$current_user->doLogin($password)) {
			$query = 'SELECT * FROM vtiger_users WHERE user_name = ?';
			$result = $adb->pquery($query, array($username));
			if ($adb->num_rows($result) > 0) {
				$status = $adb->query_result($result,0,'status');
				if($status == 'Inactive'){
					$Inactiveuser = true;
				}
			}
			if($Inactiveuser){
				$message = vtranslate('Sorry, You can\'t log in because the user is inactive','CTWhatsAppExt');
				$response->setError(1210, $message);
			}else{
				$message = vtranslate('Authentication Failed','CTWhatsAppExt');
				$response->setError(1210, $message);
			}
			
		} else {
			// Start session now
			$sessionid = CTWhatsAppExt_API_Session::init();

			if($sessionid === false) {
				$message = vtranslate('Session init failed $sessionid\n','CTWhatsAppExt');
				echo $message;
			}

			$current_user->id = $current_user->retrieve_user_id($username);
			$current_user->retrieveCurrentUserInfoFromFile($current_user->id);
			$this->setActiveUser($current_user);
			$theme = $current_user->theme_config;
			
			if($theme == 'RTL'){	
				$theme = true;
			} else if($theme == 'LTR') {
				$theme = false;
			}else{
				$theme = $current_user->theme;
				$explode_theme = explode('_',$theme);
			
				if(isset($explode_theme[1]) && $explode_theme[1] == 'rtl') {
					$theme = true;
				}else if(isset($explode_theme[1]) && $explode_theme[1] == 'ltr'){
					$theme = false;
				}else{
					$theme = false;
				}
			}
		
			$userId = $current_user->id;
			$userImage = "";
			if($userId!=''){
				$userImage = CTWhatsAppExt_WS_Utils::getUserImage($userId); // added by suresh
				
				$first_name = $current_user->first_name;
				$last_name = $current_user->last_name;
				$email =  $current_user->email1;
				$secondaryemail =  $current_user->secondaryemail;
				$phone_mobile =  $current_user->phone_mobile;
				$phone_work =  $current_user->phone_work;
				$phone_home =  $current_user->phone_home;
				$myPreference =  $site_URL.'index.php?module=Users&view=PreferenceDetail&parent=Settings&record='.$userId;
			}
			
			$moduleModel = Vtiger_Module_Model::getInstance('CTWhatsAppExt');
			if($moduleModel->get('presence') != 0){
				$message = vtranslate('Please Enable CTWhatsAppExt Module','CTWhatsAppExt');
				$response->setError(404, $message);
				return $response;	
			}

			$con_query = "SELECT * FROM ctwhatsappext_countrycode_settings";
			$con_result = $adb->pquery($con_query);
			$country_code = "";
			if($adb->num_rows($con_result)){
				$country_code = $adb->query_result($con_result,0,'country_code');
			}

			/*$licencedata = $this->getLicenseData();
			$LicenseURL = $site_URL.'index.php?module=CTWhatsAppExt&parent=Settings&view=Dashboard';
			if($licencedata['ORDER_ID']){
				$currentDate = date('Y-m-d');
				$expirydate = $licencedata['NextPaymentDate'];
				if(strtotime($expirydate) < strtotime($currentDate)){
				   $message = vtranslate('Your license has been expired','CTWhatsAppExt');
				   //$response->setError(403, $message);
				   //return $response;	
				   echo json_encode(array('success'=>false,"error"=>array("code"=>403,"message"=>$message,"URL"=>$LicenseURL)));
				   exit;
				}
			}else{
				$message = vtranslate('Setup license key first','CTWhatsAppExt');
				//$response->setError(403, $message);
				//return $response;
				echo json_encode(array('success'=>false,"error"=>array("code"=>403,"message"=>$message,"URL"=>$LicenseURL)));
				exit;
			}*/
			
			global $default_module, $upload_maxsize;

			$bytes = $upload_maxsize;
            $uploadMaxSize = $bytes/1048576;

			$result = array();
			$result['login'] = array(
				'userImage'=>$userImage,
				'userName' => $first_name." ".$last_name,
				'firstName' => $first_name,
				'lastName' => $last_name,
				'userid' => $current_user->id,
				'userwsid'=> CTWhatsAppExt_WS_Utils::getEntityModuleWSId('Users').'x'.$current_user->id,
				'email' => $email,
				'secondaryemail' => $secondaryemail,
				'phone_mobile' => $phone_mobile,
				'phone_work' => $phone_work,
				'phone_home' => $phone_home,
				'myPreference' => $myPreference,
				'is_admin'=>$current_user->is_owner,
				'crm_tz' => DateTimeField::getDBTimeZone(),
				'user_tz' => $current_user->time_zone,
				'start_hour'=>$current_user->start_hour,
                'callduration'=>$current_user->callduration,
                'eventduration'=>$current_user->othereventduration,
                'user_currency' => $current_user->currency_code,
                'currency_id'=>$current_user->currency_id,
                'currency_name'=>$current_user->currency_name,
                'currency_code'=>$current_user->currency_code,
                'currency_symbol'=>$currency_symbol,
                'currency_decimal_separator'=>$current_user->currency_decimal_separator,
                'currency_grouping_separator'=>$current_user->currency_grouping_separator,
                'currency_grouping_pattern'=>$current_user->currency_grouping_separator,
                'rtl_theme' => $theme,
                'language' => $current_user->language,
				'session'=> $sessionid,
				'due_date' => $due_date,
				'vtiger_version' => CTWhatsAppExt_WS_Utils::getVtigerVersion(),
                'date_format' => $current_user->date_format, 
				'mobile_module_version' => CTWhatsAppExt_WS_Utils::getVersion(),
				'hour_format'=>$current_user->hour_format,
				'default_module'=>$default_module,
				'ismultitenant'=>false,
				'country_code'=>$country_code,
				'upload_maxsize' => $uploadMaxSize,
			);

			$result['ModulePermission'] = $this->getPermissionModules();
			
			$response->setResult($result);
			
			$this->postProcess($response);
		
		}
		return $response;
	}

	public function getLicenseData(){
		global $adb;
		$result = $adb->pquery("SELECT * FROM ctwhatsappext_license_settings",array());
		$num_rows = $adb->num_rows($result);
		if($num_rows > 0){
			$license_key = $adb->query_result($result,0,'license_key');
			$domain = $adb->query_result($result,0,'domain');
			$url = 'https://crmtiger.com/whatsapp/checklicensewaextension.php';
			$ch = curl_init($url);
			// Setup request to send json via POST.
			$agent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)';
			$data = array( "license_key"=>$license_key,"action"=>"get_license_data","domain"=>$domain);
			curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
			// Return response instead of printing.
			curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_USERAGENT, $agent);
			// Send request.
			$result = curl_exec($ch);
			curl_close($ch);
			$licencedata = json_decode($result);
			
			$LastPaymentDate = $licencedata->PrevPaymentDate;
			$user_type = $licencedata->type;
			$NextPaymentdate = $licencedata->expirydate;

			$dateUitypes = new Vtiger_Date_UIType();
			$NextPaymentdate = $dateUitypes->getDisplayValue($NextPaymentdate);
			//$NextPaymentdate = '2023-10-01';
			$ORDER_ID = $licencedata->order_id;
			$message = $licencedata->NextPaymentdate;
			$expirydate = $licencedata->expirydate;
			$currentDate = date('Y-m-d');
			if($user_type != ''){
				if($user_type == 'Premium - One Month Free'){
					$user_type = 'Premium ( Monthly )';
				}else if($user_type == 'Free'){
					$user_type = 'Free';
				}else{
					$user_type = 'Premium ( '.$user_type.' )';
				}
				if(strtolower($user_type) != 'free' && strtotime($expirydate) < strtotime($currentDate)){
					$user_type = 'Free';
				}
				$date = strtotime($LastPaymentDate);
				$LastPaymentDate = date('d-m-Y',$date);
				$data = array("Plan"=>$user_type,"LastPaymentDate"=>$LastPaymentDate,"NextPaymentDate"=>$NextPaymentdate,'ORDER_ID'=>$ORDER_ID);
			}else{
				$data = array("Plan"=>$user_type,"LastPaymentDate"=>"","NextPaymentDate"=>"","message"=>"Invalid License Key");
			}
		}else{
			$data = array("Plan"=>"","LastPaymentDate"=>"","NextPaymentDate"=>"","message"=>"No Licence Key");
		}
		return $data;
	}

	function postProcess(CTWhatsAppExt_API_Response $response) {
		return $response;
	}

	function getPermissionModules(){
		global $current_user;
		$current_user = $this->getActiveUser();
		$presence = array('0', '2');
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		$allowedModules = array('Contacts','Leads','Accounts','Vendors');
		$Modules = array();
		foreach($allowedModules as $key => $moduleName){
			$moduleModel = Vtiger_Module_Model::getInstance($moduleName);
				if (($userPrivModel->isAdminUser() ||
							$userPrivModel->hasGlobalReadPermission() ||
							$userPrivModel->hasModulePermission($moduleModel->getId())) && in_array($moduleModel->get('presence'), $presence)) {
					$editAction = $userPrivModel->hasModuleActionPermission($moduleModel->getId(), 'EditView');
					$createAction = $userPrivModel->hasModuleActionPermission($moduleModel->getId(), 'CreateView');
					$Modules[] = array(
						'id'=> $moduleModel->get('id'),
						'name' => trim($moduleModel->get('name')),
						'isEntity' => $moduleModel->get('isentitytype'),
						'label' => vtranslate($moduleModel->get('label'),$moduleName),
						'singular' => vtranslate($moduleModel->get('name'),$moduleName),
						'img_url' => $this->getImageURL($moduleName),
						'createAction' => $createAction,
						'editAction' => $editAction
						);
				}
		}
		return $Modules;
	}

	function getImageURL($modulename) {
		global $adb,$site_URL;
		$img_url = '';	
		$filename = 'modules/CTWhatsAppExt/MobileIcon/'.$modulename.'.png';
		
		if (file_exists($filename)) {
			$img_url = $site_URL.'modules/CTWhatsAppExt/MobileIcon/'.$modulename.'.png';
		}	
		return $img_url;	
	}
}
