<?php
 /*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */

class CTWhatsAppExt_WS_MassSaveRecord extends CTWhatsAppExt_WS_Controller {

	function process(CTWhatsAppExt_API_Request $request) {
		global $current_user,$adb, $site_URL,$VTIGER_BULK_SAVE_MODE;
		$current_user = $this->getActiveUser();
		$assignedUserId = $current_user->id;
		$module = $request->get('module');
		$values = $request->get('values');
		if(!is_array($values)){
			$values = Zend_Json::decode($values);
		}
		if($module == ''){
			throw new WebServiceException(404,'Module is required');
		}
		if($values == ''){
			throw new WebServiceException(404,'values is required');
		}
		/*$VTIGER_BULK_SAVE_MODE = true;*/
		$records = array();
		foreach ($values as $key => $value) {
			$mode = 'create';
			$recordModel = Vtiger_Record_Model::getCleanInstance($module);
			$recordModel->set('mode', '');
			foreach ($value as $keys => $fieldvalue) {
				$recordModel->set($keys, $fieldvalue);
			}
			$recordModel->set('assigned_user_id', $assignedUserId);
			$recordModel->save();
			$lastInsertId = $recordModel->getId();
			$recordLabel = $recordModel->get('label');
			$records[] = array('recordid'=>$lastInsertId,'recordLabel'=>$recordLabel);
		}
		/*$VTIGER_BULK_SAVE_MODE = false;*/

		$message = vtranslate('Records saved successfully','CTWhatsAppExt');
		$result = array('records'=>$records,'module'=>$module,'message'=>$message);

		// Gather response with full details
		$response = new CTWhatsAppExt_API_Response();
		$response->setResult($result);
		return $response;

	}
}