<?php
/*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */
include_once 'include/Webservices/DescribeObject.php';
include_once dirname(__FILE__) . '/FetchRecord.php';

class CTWhatsAppExt_WS_NewDescribe extends CTWhatsAppExt_WS_FetchRecord {
	
	function process(CTWhatsAppExt_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $adb;
		$current_user = $this->getActiveUser();
		$roleid = $current_user->roleid;
		$module = trim($request->get('module'));
		$isFilter = trim($request->get('isFilter'));
		$record = trim($request->get('record'));

		if(!empty($record)){
			$result_response = parent::process($request);
			$result_record = $result_response->getResult();
			$resultRecord = $result_record['record'];
			$recordid = explode("x",$resultRecord['id']);
		}

		if($module == 'Users'){
			$current_user = Users::getActiveAdminUser();
		}
		$describeInfo = vtws_describe($module, $current_user);
		$fields = $describeInfo['fields'];

		$moduleModel = Vtiger_Module_Model::getInstance($module);
		//$describeInfo['singularLabelName'] = vtranslate($moduleModel->getSingularLabelKey(), $moduleModel->getName());
		$QuickCreateAction = $moduleModel->isQuickCreateSupported();
		$describeInfo['QuickCreateAction'] = $QuickCreateAction;
		$fieldModels = $moduleModel->getFields();
		
		if($module == 'Events'){
			$modulename = 'Calendar';
		}else{
			$modulename = $module;
		}
		$refrenceUitypes = array(10,51,57,58,59,66,73,75,76,77,78,80,81,101);
		// code start for Entity Field By suresh /
		$entityQuery = $adb->pquery("SELECT * FROM vtiger_entityname WHERE modulename = ?",array($modulename));
		$entityField = $adb->query_result($entityQuery,0,'fieldname');
		$entityField_array = explode(',',$entityField);
		$entityField = $entityField_array[0];
		$tabid = getTabid($modulename);
		
		$entityQuery11 = $adb->pquery("SELECT * FROM vtiger_field WHERE columnname = ? and tabid= ?",array($entityField,$tabid));
		$fieldlabel = $adb->query_result($entityQuery11,0,'fieldlabel');
		$fieldlabel = vtranslate($fieldlabel,$modulename);
		
		$describeInfo['entityField'] = array('label'=>$fieldlabel,'value'=>$entityField);
		
		// code End for Entity Field By suresh /
		
		foreach($fields as $index=>$field) {
			
			if($field['name'] == 'currency_id' && $module == 'PriceBooks'){
				$field['type'] = array();
				$query = "SELECT id,currency_name FROM  `vtiger_currency_info` WHERE currency_status = 'Active' AND deleted = 0";
				$result = $adb->pquery($query,array());
				$numrows = $adb->num_rows($result);
				$query2 = "SELECT id FROM vtiger_ws_entity WHERE name = 'Currency'";
				$resullt2 = $adb->pquery($query2,array());
				$id = $adb->query_result($resullt2,0,'id');
				for($i=0;$i<$numrows;$i++){
					$currency_name = $adb->query_result($result,$i,'currency_name');
					$value = $adb->query_result($result,$i,'id');
					$picklistValues[] = array('label'=>$currency_name,'value'=>$id.'x'.$value);
				}
				$field['type']['picklistValues'] = $picklistValues;
				$field['type']['defaultValue'] = trim($picklistValues[0]['value']);
				$field['type']['name'] = 'picklist';
			}
			if($field['name'] == 'folderid' && $module == 'Documents'){
				$field['type'] = array();
				$query = "SELECT folderid,foldername FROM  `vtiger_attachmentsfolder` ORDER BY sequence ASC";
				$result = $adb->pquery($query,array());
				$numrows = $adb->num_rows($result);
				$query2 = "SELECT id FROM vtiger_ws_entity WHERE name = 'DocumentFolders'";
				$resullt2 = $adb->pquery($query2,array());
				$id = $adb->query_result($resullt2,0,'id');
				for($i=0;$i<$numrows;$i++){
					$foldername = $adb->query_result($result,$i,'foldername');
					$folderid = $adb->query_result($result,$i,'folderid');
					$picklistValues[] = array('label'=>$foldername,'value'=>$id.'x'.$folderid);
				}
				$field['type']['picklistValues'] = $picklistValues;
				$field['type']['defaultValue'] = trim($picklistValues[0]['value']);
				$field['type']['name'] = 'picklist';
			}
			$fieldModel = $fieldModels[$field['name']];
			$fieldBlock = $fieldModel->block;
			$fieldId = $fieldModel->id;
			
			$restrictedFields = array('duration_hours','tax1','tax2','tax3','isconvertedfromlead','filelocationtype','filestatus','fileversion');
			if(in_array($field['name'],$restrictedFields)){
					unset($field);
					continue;
			}
			if(($field['name'] == 'modifiedby'  ) && ($module == 'Calendar' || $module == 'Events')){
				continue;
			}
			
			if(($module == 'Calendar' || $module == 'Events') && ($field['name'] == 'activitytype')){
				$defaultactivitytype = $current_user->defaultactivitytype;
				if($defaultactivitytype != ''){
					$field['default'] = trim($defaultactivitytype);
				}
			}
			if(($module == 'Calendar' || $module == 'Events') && ($field['name'] == 'eventstatus')){
				$defaulteventstatus = $current_user->defaulteventstatus;
				if($defaulteventstatus != ''){
					$field['default'] = trim($defaulteventstatus);
				}
			}
			if(($module == 'Calendar') && ($field['name'] == 'time_end')){
				continue;
			}

			if($field['default'] != '' && $field['type']['name'] == 'picklist'){
				$field['type']['defaultValue'] = trim($field['default']);
			}else{
				$field['type']['defaultValue'] = trim($field['default']);
			}
			
			if($field['type']['defaultValue'] == 'Select an Option'){
				 $field['type']['defaultValue'] = ""; 
			}
			
			if($fieldModel) {
				$displaytype = $fieldModel->get('displaytype');
				$uitype =  $fieldModel->get('uitype');
				if($uitype == 15 || $uitype == 33){
					$picklistValues1 = array();
					$picklistValues = Vtiger_Util_Helper::getRoleBasedPicklistValues($field['name'],$roleid);
					foreach($picklistValues as $pvalue){
						$picklistValues1[] = array('value'=>$pvalue, 'label'=>vtranslate($pvalue,$module));
						$field['type']['picklistValues'] = $picklistValues1;
					}
					
					
				}
				if($uitype == 33){
						$field['type']['defaultValue'] = "";
					}
				//remove Image Field 
				if($uitype == 69 && $field['name'] != 'imagename'){
					unset($field);
					continue;
				}
				$allowedFields = array('productid','time_start','time_end','duration_hours');
				if($isFilter === 'true'){
					$allowedFields[] = 'modifiedtime';
					$allowedFields[] = 'createdtime';
				}
				if($displaytype != 1 && !in_array($field['name'],$allowedFields)){
					unset($field);
					continue;
				}
				
				$field['headerfield'] = $fieldModel->get('headerfield');
				$field['summaryfield'] = $fieldModel->get('summaryfield');
				$field['uitype'] = $fieldModel->get('uitype');
				$field['typeofdata'] = $fieldModel->get('typeofdata');
				$field['displaytype'] = $fieldModel->get('displaytype');
				$field['quickcreate'] = $fieldModel->get('quickcreate');
				$field['blockId'] = $fieldBlock->id;
				$field['blockname'] = vtranslate($fieldBlock->label, $module);
				$getSequencefieldQuery = $adb->pquery("SELECT sequence from vtiger_field where fieldid = ?", array($fieldId));
				$sequence = $adb->query_result($getSequencefieldQuery, 0, 'sequence');
				$field['sequence'] = $sequence;
			}
			
			if($fieldModel && $fieldModel->getFieldDataType() == 'owner') {
				$currentUser = Users_Record_Model::getCurrentUserModel();
                $users = $currentUser->getAccessibleUsers();
                $usersWSId = CTWhatsAppExt_WS_Utils::getEntityModuleWSId('Users');
                foreach ($users as $id => $name) {
                    unset($users[$id]);
                    $users[$usersWSId.'x'.$id] = $name; 
                }
                
                $groups = $currentUser->getAccessibleGroups();
                $groupsWSId = CTWhatsAppExt_WS_Utils::getEntityModuleWSId('Groups');
                foreach ($groups as $id => $name) {
                    unset($groups[$id]);
                    $groups[$groupsWSId.'x'.$id] = $name; 
                }

				//Special treatment to set default mandatory owner field
				if (!$field['default']) {
					$field['default'] = $usersWSId.'x'.$current_user->id;
				}
			}

			if($field['type']['name'] == 'reference'){
				$refersTo = $field['type']['refersTo'];
				$refModule = array();
				if(!empty($refersTo)){
					foreach ($refersTo as $key => $rModule) {
						if($field['name'] != 'salesorder_id' && $field['name'] != 'assigned_user_id1' && $field['name'] != 'quote_id' && $field['name'] != 'invoiceid' && $field['name'] != 'productid'){
							if($rModule == 'Events'){
								$referenceModuleModel = Vtiger_Module_Model::getInstance('Calendar');
							}else{
								$referenceModuleModel = Vtiger_Module_Model::getInstance($rModule);
							}
							$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
							$createAction = $userPrivModel->hasModuleActionPermission($referenceModuleModel->getId(), 'CreateView');
							if($createAction){
								$isQuickCreate = true;
							}else{
								$isQuickCreate = false;
							}	
						}else{
							$isQuickCreate = false;
						}
						$refModule[] = array('value'=>$rModule,'label'=>vtranslate($rModule,$rModule),'isQuickCreate' => $isQuickCreate);
					}
					$field['type']['refersTo'] = $refModule;
				}
			}

			if($fieldModel && $fieldModel->get('name') == 'salutationtype') {
				$values = $fieldModel->getPicklistValues();
				$picklistValues = array();
				foreach($values as $value => $label) {
					$picklistValues[] = array('value'=>trim($value), 'label'=>trim($label));
				}
				$field['type']['picklistValues'] = $picklistValues;
			}
			//code start by suresh for isInContextmenu
			if($module == 'Leads'){
				$isInContextmenuFields = array('firstname','lastname','company','phone','email');
			}else if($module == 'Contacts'){
				$isInContextmenuFields = array('firstname','lastname','phone','email');
			}else if($module == 'Accounts'){
				$isInContextmenuFields = array('accountname','website','phone');
			}else if($module == 'Contacts'){
				$isInContextmenuFields = array('vendorname','website','phone','email');
			}else{
				$isInContextmenuFields =  array();
			}

			if(in_array($field['name'], $isInContextmenuFields)){
				$field['isInContextmenu'] = true;
			}else{
				$field['isInContextmenu'] = false;
			}//code end by suresh for isInContextmenu

			//code start for Edit
			if(!empty($record)){
				$fieldname = $field['name'];
				if(isset($resultRecord[$fieldname])){
					if(in_array($field['uitype'], $refrenceUitypes)){
						$recordValue = explode("x",$resultRecord[$fieldname]['value']);
						$getReferenceModuleName = $adb->pquery("SELECT name FROM vtiger_ws_entity WHERE id =?", array($recordValue[0]));
						$referenceModuleName = $adb->query_result($getReferenceModuleName, 0, 'name');
						$field['value'] = array('value'=> $resultRecord[$fieldname]['value'], 'module' => $referenceModuleName, 'label' => $resultRecord[$fieldname]['label']);
					}else if(in_array($field['uitype'], array('5','6','23'))){
						$field['value'] = $resultRecord[$fieldname];
					}else if($field['uitype'] == 53){
						$field['value'] = array('value'=> $resultRecord[$fieldname]['value'], 'label' => $resultRecord[$fieldname]['label']);
					}else if($field['uitype'] == 33){
						$field['value'] = str_replace(' |##| ', ',',$resultRecord[$fieldname]);
					}else if($fieldname =='time_start' || $fieldname =='time_end'){
						$date = new DateTime();
						$dateTime = new DateTimeField($date->format('Y-m-d').' '.$resultRecord[$fieldname]);
						$value = Vtiger_Time_UIType::getDisplayValue($dateTime->getDisplayTime());
						$field['value'] = $value;
					}else if($field['uitype'] == 71 || $field['uitype'] == 30){
						$recordModel = Vtiger_Record_Model::getInstanceById($recordid[1],$module);
						$value = $fieldModel->getDisplayValue($resultRecord[$fieldname], $record, $recordModel);
						$field['value'] = str_replace(',', '', $value);
						if($fieldname =='reminder_time' && $resultRecord['reminder_time'] != ''){
						   $reminder = $resultRecord['reminder_time'];
						   $minutes = (int)($reminder)%60;
						   $hours = (int)($reminder/(60))%24;
						   $days =  (int)($reminder/(60*24));
						   $field['reminder_value'] = array('days'=>$days,'hours'=>$hours,'minutes'=>$minutes);
					    }
					}else if($fieldname == 'recurringtype'){
						$field['value'] = $this->RecurringDetails($recordid[1], $module);
						$recordModel = Vtiger_Record_Model::getInstanceById($recordid[1], $module);
						$recurringInfo = $recordModel->getRecurringDetails();
						$getRecurringEventData = 'SELECT vtiger_recurringevents.*, vtiger_activity.date_start, vtiger_activity.time_start, vtiger_activity.due_date, vtiger_activity.time_end FROM vtiger_recurringevents INNER JOIN vtiger_activity ON vtiger_activity.activityid = vtiger_recurringevents.activityid WHERE vtiger_recurringevents.activityid = ?';
						$getRecurringEventResult = $adb->pquery($getRecurringEventData, array($recordid[1]));

						$recurringEventData = array();
						if ($adb->num_rows($getRecurringEventResult)) {
							$recurringEventData = RecurringType::fromDBRequest($adb->query_result_rowdata($getRecurringEventResult, 0));
						}//end of if

						if($recurringEventData){
							$recurringInfo['recurringcheckVal'] = 1;
						}else{
							$recurringInfo['recurringcheckVal'] = 0;
						}//end of else

						if(!empty($recurringInfo['repeat_str'])){
							$recurringType = '';
							if($recurringInfo['recurringtype'] == 'Monthly'){
								if($recurringInfo['repeatMonth_daytype'] != ''){
									$repeat_str = explode(' ',$recurringInfo['repeat_str']);
									$recurringType .= ' '.$repeat_str[0].' ';
									$recurringType .= $repeat_str[1].' ';
									$recurringType .= vtranslate(trim($repeat_str[2]),$module);
								}else{
									$repeat_str = explode('  ',$recurringInfo['repeat_str']);
									$recurringType .= ' '.$repeat_str[0].' ';
									$recurringType .= vtranslate(trim($repeat_str[1]),$module);
								}//end of else
							}else{
								$repeat_str = explode(' ',$recurringInfo['repeat_str']);
								$recurringType .= ' '.$repeat_str[0].' ';
								$repeat_str1 = explode(',',$repeat_str[1]);
								foreach($repeat_str1 as $key => $r){
									if($key == count($repeat_str1)-1){
										$recurringType .= vtranslate(trim($r),$module);
									}else{
										$recurringType .= vtranslate(trim($r),$module).',';
									}//end of else
								}//end of foreach
							}//end of else

							if($recurringInfo['recurringtype'] == 'Weekly'){
								$recurringInfo['repeat_str_label'] = $recurringInfo['repeat_str'];
							}//end of if
							$recurringInfo['repeat_str'] = $recurringType;
						}//end of if
						if($recurringInfo['recurringenddate'] != ''){
							if($current_user->date_format == 'mm-dd-yyyy'){
								$dateFormat = 'm-d-Y';
							}else if($current_user->date_format == 'dd-mm-yyyy'){
								$dateFormat = 'd-m-Y';
							}else if($current_user->date_format == 'dd.mm.yyyy'){
								$dateFormat = 'd.m.Y';
							}else if($current_user->date_format == 'dd/mm/yyyy'){
								$dateFormat = 'd/m/Y';
							}else{
								$dateFormat = 'Y-m-d';
							}//end of else

							$dateTime = DateTime::createFromFormat($dateFormat, $recurringInfo['recurringenddate']);
							if($dateTime){
								$formattedDate = $dateTime->format('Y-m-d');
								$recurringInfo['recurringenddate'] = $formattedDate;
							}//end of if
							/*$recurringDefaultEndDateFormat = strtotime($recurringInfo['recurringenddate']);
							$recurringEndDateNewFormat = date('Y-m-d', $recurringDefaultEndDateFormat);
							$recurringInfo['recurringenddate'] = $recurringEndDateNewFormat;*/
						}
						$field['recurring_value'] = $recurringInfo;
					}else{
						$field['value'] = $resultRecord[$fieldname];
					}
				}else{
					$field['value'] = "";
				}
			}

			$newFields[] = $field;
		}

		if($module == 'Events'){
			$field = array();
			$query = "SELECT * FROM vtiger_users WHERE status='Active' AND is_owner!=1";
			$result = $adb->pquery($query, array());
			$picklistValues = Array();
			if($adb->num_rows($result) > 0) {
				while ($row = $adb->fetch_array($result)) {
					//Need to decode the picklist values twice which are saved from old ui
					$value = $row['first_name'].' '.$row['last_name'];
					$picklistValues[]= array('value'=>decode_html($row['id']), 'label'=>decode_html($value));
				}
			}

			$getInvites = $adb->pquery("SELECT * FROM vtiger_invitees where activityid = ?", array($recordid[1]));
			$countInvities = $adb->num_rows($getInvites);
			$selectedValue = '';
			$inviteUserValue = array();
			for($i=0;$i<$countInvities;$i++){
				$inviteId = $adb->query_result($getInvites, $i, 'inviteeid');
				$userRecordModel = Vtiger_Record_Model::getInstanceById($inviteId, 'Users');
				$firstName = $userRecordModel->get('first_name');
				$firstName = html_entity_decode($firstName, ENT_QUOTES, $default_charset);
				$lastName = $userRecordModel->get('last_name');
				$lastName = html_entity_decode($lastName, ENT_QUOTES, $default_charset);
				if($i == 0) {
					$selectedValue .= $inviteId;
				} else {
					$selectedValue .= ",".$inviteId;
				}//end of else
				$inviteUserValue[] = array('value' => $inviteId, 'label' => $firstName." ".$lastName);
			}//end of for
			
			$field['name'] = "invite_user";
			$field['label'] = "Invite People";
			$field['mandatory'] = false;
			$field['type']['picklistValues'] = $picklistValues;
            $field['type']['defaultValue'] = trim($picklistValues[0]['value']);
			
			if($field['type']['defaultValue'] == 'Select an Option'){
				 $field['type']['defaultValue'] = ""; 
			}
			
			$field['type']['name'] = "multipicklist";
			$field['nullable'] = "true";
			$field['editable'] = "true";
			$field['default'] = "";
			$field['headerfield'] = "null";
			$field['summaryfield'] = "0";
			$field['uitype'] = "33";
			$field['typeofdata'] = "V~O";
			$field['displaytype'] = "1";
			$field['quickcreate'] = "1";
			$field['blockId'] = "130";
			$field['blockname'] = "Invite";
			$field['sequence'] = "1";
			$field['isInContextmenu'] = false; //added by suresh
			$field['invite_user_value'] = $inviteUserValue;
			$field['value'] = $selectedValue;
			$newFields[] = $field;
		}
		/*foreach($newFields as $key=> $fields){
			$newFields[$key]['label'] = html_entity_decode($fields['label'], ENT_QUOTES, $default_charset);
		}*/

		$entityFieldValue = '';
		foreach($newFields as $key=> $fields){
			$newFields[$key]['label'] = html_entity_decode($fields['label'], ENT_QUOTES, $default_charset);
			if($newFields[$key]['name'] == $entityField || $newFields[$key]['label'] == $fieldlabel){
				$entityFieldValue = $newFields[$key]['value'];
			}//end of if
		}

		$fields=null;
		$describeInfo['fields'] = $newFields;

		$describeInfo['singularLabelName'] = vtranslate('LBL_EDITING', $moduleModel->getName()).' '.vtranslate($moduleModel->getSingularLabelKey(), $moduleModel->getName()).' - '.$entityFieldValue;
		
		$response = new CTWhatsAppExt_API_Response();
		$response->setResult(array('describe' => $describeInfo));
		
		return $response;
	}

	function RecurringDetails($recordId, $module){
		$recordModel = Vtiger_Record_Model::getInstanceById($recordId,$module);
		$recurringInfo = $recordModel->getRecurringDetails();
		if($recurringInfo['recurringcheck'] == 'Yes'){
			$recurringType = vtranslate('LBL_REPEATEVENT', $module).'  '.$recurringInfo['repeat_frequency'].' '.vtranslate($recurringInfo['recurringtype'], $module);
			if(!empty($recurringInfo['repeat_str'])){
				if($recurringInfo['recurringtype'] == 'Monthly'){
					if($recurringInfo['repeatMonth_daytype'] != ''){
						$repeat_str =explode(' ',$recurringInfo['repeat_str']);
						$recurringType .= ' '.$repeat_str[0].' ';
						$recurringType .= $repeat_str[1].' ';
						$recurringType .= vtranslate(trim($repeat_str[2]),$module);
					}else{
						$repeat_str =explode('  ',$recurringInfo['repeat_str']);
						$recurringType .= ' '.$repeat_str[0].' ';
						$recurringType .= vtranslate(trim($repeat_str[1]),$module);
					}//end of else
				}else{
					$repeat_str =explode(' ',$recurringInfo['repeat_str']);
					$recurringType .= ' '.$repeat_str[0].' ';
					$repeat_str1 = explode(',',$repeat_str[1]);
					foreach($repeat_str1 as $key => $r){
						if($key == count($repeat_str1)-1){
							$recurringType .= vtranslate(trim($r),$module);
						}else{
							$recurringType .= vtranslate(trim($r),$module).',';
						}//end of else
					}//end of foreach
				}//end of else
			}//end of if
			if($current_user->date_format == 'mm-dd-yyyy'){
				$dateFormat = 'm-d-Y';
			}else if($current_user->date_format == 'dd-mm-yyyy'){
				$dateFormat = 'd-m-Y';
			}else{
				$dateFormat = 'Y-m-d';
			}//end of else

			$dateTime = DateTime::createFromFormat($dateFormat, $recurringInfo['recurringenddate']);
			if($dateTime){
				$formattedDate = $dateTime->format('Y-m-d');
				$recurringInfo['recurringenddate'] = $formattedDate;
			}//end of if

			/*$recurringDefaultEndDateFormat = strtotime($recurringInfo['recurringenddate']);
			$recurringEndDateNewFormat = date('Y-m-d', $recurringDefaultEndDateFormat);
			$recurringenddate = $recurringEndDateNewFormat;*/

			$recurringType .= ' '.vtranslate('LBL_UNTIL', $module).' '.$recurringenddate;
		}else{
			$recurringType = $recurringInfo['recurringcheck'];
		}//end of else
		return $recurringType;
	}//end of function

}
?>