<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
include_once 'modules/CustomView/CustomView.php';

class CTWhatsAppExt_WS_FilterModel {
	
	var $filterid, $moduleName;
	var $user;
	protected $customView;
	
	function __construct($moduleName) {
		$this->moduleName = $moduleName;
		$this->customView = new CustomView($moduleName);
	}
	
	function setUser($userInstance) {
		$this->user = $userInstance;
	}
	
	function getUser() {
		return $this->user;
	}
	
	function query() {
		// $listquery = getListQuery($this->moduleName);
		// $query = $this->customView->getModifiedCvListQuery($this->filterid,$listquery,$this->moduleName);
		
		$listViewModel = Vtiger_ListView_Model::getInstance($this->moduleName, $this->filterid);
		$query = $listViewModel->getQuery();
		return $query;
	}
	
	function queryParameters() {
		return false;
	}
	
	static function modelWithId($moduleName, $filterid) {
		$model = new CTWhatsAppExt_WS_FilterModel($moduleName);
		$model->filterid = $filterid;
		return $model;
	}
	
}
