<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

Class CTWhatsAppExt_CTLanguageAjax_View extends Vtiger_IndexAjax_View {

    public function process(Vtiger_Request $request) {
        global $adb;
        $viewer = $this->getViewer ($request);
        $ctlanguage = $request->get('ctlanguage');
        $module = $request->getModule();
        $qualifiedModuleName = $request->getModule(false);
        $LanguageFields = $this->getLanguageFields($ctlanguage);
        $viewer->assign('CTLANGAUGE', $ctlanguage);
        $viewer->assign('CTLANGUAGE_SECTION', $ctlanguage_section);
        $viewer->assign('LANGUAGE_FIELDS', $LanguageFields);
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('SOURCE_MODULE', $module);
        $viewer->assign('MODULE', $module);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModuleName);
        $viewer->view('CTLanguageFields.tpl', $qualifiedModuleName);
    }

    public function getLanguageFields($language){
        global $adb;
        $query = "SELECT * FROM ctwhatsappext_language_keyword WHERE keyword_lang = ? ";
        $results = $adb->pquery($query,array($language));
        $numRows = $adb->num_rows($results);
        $fields = array();
        if($numRows){
            for($i=0;$i<$numRows;$i++){
                $keyword_id = $adb->query_result($results,$i,'keyword_id');
                $keyword_name = $adb->query_result($results,$i,'keyword_name');
                $language_keyword = $adb->query_result($results,$i,'language_keyword');
                $fields[] = array('keyword_id'=>$keyword_id,'keyword_name'=>$keyword_name,'language_keyword'=>$language_keyword);
            }
        }
        return $fields;
    }
}
