<?php
/*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */
class CTWhatsAppExt_CTMaxPhoneNumberDigit_View extends Settings_Vtiger_Index_View {

	function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('WhatsApp Chrome - Settings', $qualifiedModuleName).' > '.vtranslate('Max. Phone Number Digit Setup',$qualifiedModuleName);
    }
    
    public function process(Vtiger_Request $request){
        $viewer = $this->getViewer($request);
        $qualifiedName = $request->getModule(false);
		$maxNumberDigit =  $this->getMaxPhoneNumberDigit();

        $viewer->assign('MAX_NUMBER_DIGIT',$maxNumberDigit);
        $viewer->assign('MODULE','CTWhatsAppExt');
        $viewer->view('CTMaxPhoneNumberDigit.tpl',$qualifiedName);
    }//end of function
		
   function getHeaderScripts(Vtiger_Request $request) {
		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(
			"modules.Settings.$moduleName.resources.CTMaxPhoneNumberDigit",
			"modules.Vtiger.resources.SearchList",
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);

		return $headerScriptInstances;
    }//end of function

    function getMaxPhoneNumberDigit(){
		global $adb;
		$getMaxNumberDigitData = $adb->pquery("SELECT * FROM ctwhatsappext_phonenumberdigit_settings");
		$numOfNumberDigit = $adb->num_rows($getMaxNumberDigitData);

		$maxNumberDigit = '';
        if($numOfNumberDigit > 0){
			$maxNumberDigit = $adb->query_result($getMaxNumberDigitData, 0, 'max_number_digit');
		}//end of if

		return $maxNumberDigit;
	}//end of function
}//end of class
    
