<?php
class CTWhatsAppExt_CTScheduleList_View extends Settings_Vtiger_Index_View {
    function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('WhatsApp Chrome - Settings', $qualifiedModuleName) . ' > ' . vtranslate('Schedule Message Setup', $qualifiedModuleName);
    }//end of function
    public function process(Vtiger_Request $request) {
        global $adb, $list_max_entries_per_page, $current_user;
        $viewer = $this->getViewer($request);
        $qualifiedName = $request->getModule(false);

        // Total number of records
        $query = $adb->pquery("SELECT COUNT(*) AS total_records FROM ctwhatsappext_waschedulemessages");
        $total_records = $adb->query_result($query, 0, 'total_records');

        // Current page
        $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
        if ($current_page < 1) $current_page = 1;

        $offset = ($current_page - 1) * $list_max_entries_per_page;

        $selectDataQuery = $adb->pquery("SELECT * FROM ctwhatsappext_waschedulemessages ORDER BY messagesenddate DESC, messagesendtime DESC LIMIT $offset, $list_max_entries_per_page", array());
        $selectedRows = array();
        while ($row = $adb->fetch_array($selectDataQuery)) {
            $selectedRows[] = $row;
        }

        foreach ($selectedRows as $entry) {
            // Decode the message field
            $message = json_decode(html_entity_decode($entry['message'], ENT_QUOTES | ENT_HTML5));
            $message = str_replace(['&gt;', '&lt;', '&amp;'], ['>', '<', '&'], $message);
            $entry['message'] = preg_replace("#\*([^*]+)\*#", "<b>$1</b>", $message);

            $messageSendDate = $entry['messagesenddate'];
            $dateFieldObj = new DateTimeField($messageSendDate);
            $entry['messagesenddate'] = $dateFieldObj->getDisplayDate($current_user);
            
            if($current_user->hour_format == '12'){
                $entry['messagesendtime'] = Vtiger_Time_UIType::getTimeValueInAMorPM($entry['messagesendtime']);
            }//end of if

            $html = '<td class="listViewEntryValuemessage" title="' . htmlspecialchars($entry['message'], ENT_QUOTES, 'UTF-8') . '">';
            $rawMessage = html_entity_decode($entry['message'], ENT_QUOTES, 'UTF-8');
            $length = mb_strlen($rawMessage, 'UTF-8');
            if ($length > 20) {
                $html .= mb_substr($rawMessage, 0, 20, 'UTF-8') . '...';
            } else {
                $html .= $rawMessage;
            }
            if ($entry['attachedfilename'] != '' && $entry['attachedfiledata'] != '') {
                $html .= '<br><span class="tab-icon"><i class="vicon-documents" title="' . $entry['attachedfilename'] . '"></i></span>';
            }

            $html .= '</td>';
            $entry['html'] = $html;

            $decodedMessages[] = $entry;
        }

        $viewer->assign('LISTVIEW_ENTRIES', $decodedMessages);
        $viewer->assign('LISTVIEW_COUNT', $total_records);

        // Pagination links
        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set('page', $current_page);
        $pagingModel->set('limit', $list_max_entries_per_page);

        $total_pages = ceil($total_records / $list_max_entries_per_page);
        $nextPage = ($current_page < $totalPages);
        $previousPage = ($current_page > 1);

        $viewer->assign('PAGING_MODEL', $pagingModel);
        $viewer->assign('PAGE_NUMBER', $current_page);
        $viewer->assign('TOTAL_PAGES', $total_pages);
        $viewer->assign('PAGE_LIMIT', $list_max_entries_per_page);
        $viewer->assign('NEXT_PAGE', $current_page < $total_pages);
        $viewer->assign('PREVIOUS_PAGE', $current_page > 1);
        $viewer->assign('MODULE', 'Settings:CTWhatsAppExt');
        $viewer->view('CTScheduleMessage.tpl', $qualifiedName);
    }
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.Settings.$moduleName.resources.CTScheduleMessage",
            "modules.Vtiger.resources.SearchList",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);

        return $headerScriptInstances;
    }//end of function
}

?>
