<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTWhatsAppExt_CountryCode_View extends Settings_Vtiger_Index_View {

	function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('WhatsApp Chrome - Settings',$qualifiedModuleName).' > '.vtranslate('Country Code Setup',$qualifiedModuleName);
    }
    
    public function process(Vtiger_Request $request){
        $viewer = $this->getViewer($request);
        $qualifiedName = $request->getModule(false);
		$country_code =  $this->getCountryCode();
        $viewer->assign('COUNTRY_CODE',$country_code);
        $viewer->assign('MODULE','CTWhatsAppExt');
        $viewer->view('CountryCode.tpl',$qualifiedName);
    }
		
   function getHeaderScripts(Vtiger_Request $request) {
		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(
			"modules.Settings.$moduleName.resources.CountryCode",
			"modules.Vtiger.resources.SearchList",
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
		return $headerScriptInstances;
    }

    function getCountryCode(){
		global $adb;
		$getLicenseQuery=$adb->pquery("SELECT * FROM ctwhatsappext_countrycode_settings");
		$numOfLicense = $adb->num_rows($getLicenseQuery);
        if($numOfLicense > 0){
			$country_code = $adb->query_result($getLicenseQuery,0,'country_code');
		}else{
			$country_code = '';
		}
		return $country_code;
	}
}
    
