<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTWhatsAppExt_License_View extends Settings_Vtiger_Index_View {

    function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('WhatsApp Ext Setting',$qualifiedModuleName);
    }
    
    public function process(Vtiger_Request $request){
        $viewer = $this->getViewer($request);
        $qualifiedName = $request->getModule(false);

		$license_key =  $this->getLicense();
		$LicenseData = $this->getLicenseData();
        $viewer->assign('LICENCE_KEY',$license_key);
        $viewer->assign('LICENCE_DATA',$LicenseData);
        $viewer->assign('DIFFERENCE_DATE',$difference_date);
        $viewer->assign('MODULE','CTWhatsAppExt');
        $viewer->assign('PREMIUM_LINK','https://crmtiger.com/whatsapp/?product=whatsapp-chrom-extension-with-vtigermonthly');
        $viewer->assign('LANGUAGE_LINK','index.php?module=CTWhatsAppExt&parent=Settings&view=CTLanguage');
        $viewer->assign('UPDATE_LICENSE_KEY','index.php?module=CTWhatsAppExt&parent=Settings&view=LicenseEdit');
        $viewer->assign('HELP','https://kb.crmtiger.com/article-categories/whatsapp-chrome-extension-for-vtiger/');
        $viewer->assign('COUNTRY_CODE','index.php?module=CTWhatsAppExt&parent=Settings&view=CountryCode');
        $viewer->view('License.tpl',$qualifiedName);
    }
		
   function getHeaderScripts(Vtiger_Request $request) {
		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(
			"modules.Settings.$moduleName.resources.License",
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
		return $headerScriptInstances;
    }

    function getLicense(){
		global $adb;
		$getLicenseQuery=$adb->pquery("SELECT * FROM ctwhatsappext_license_settings");
		$numOfLicense = $adb->num_rows($getLicenseQuery);
        if($numOfLicense > 0){
			$license_key = $adb->query_result($getLicenseQuery,0,'license_key');
		}else{
			$license_key = '';
		}
		return $license_key;
	}

	public function getLicenseData(){
		global $adb;
		$result = $adb->pquery("SELECT * FROM ctwhatsappext_license_settings",array());
		$num_rows = $adb->num_rows($result);
		if($num_rows > 0){
			$license_key = $adb->query_result($result,0,'license_key');
			$domain = $adb->query_result($result,0,'domain');
			$url = 'https://crmtiger.com/whatsapp/checklicensewaextension.php';
			$ch = curl_init($url);
			// Setup request to send json via POST.
			$agent = 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)';
			$data = array( "license_key"=>$license_key,"action"=>"get_license_data","domain"=>$domain);
			curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
			// Return response instead of printing.
			curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_USERAGENT, $agent);
			// Send request.
			$result = curl_exec($ch);
			curl_close($ch);
			$licencedata = json_decode($result);
			
			$LastPaymentDate = $licencedata->PrevPaymentDate;
			$user_type = $licencedata->type;
			$NextPaymentdate = $licencedata->expirydate;

			$dateUitypes = new Vtiger_Date_UIType();
			$NextPaymentdate = $dateUitypes->getDisplayValue($NextPaymentdate);
			
			$ORDER_ID = $licencedata->order_id;
			$message = $licencedata->NextPaymentdate;
			$expirydate = $licencedata->expirydate;
			$currentDate = date('Y-m-d');
			$dateFrom = new DateTime($currentDate);
			$dateTo = new DateTime($expirydate);

			$difference_date = $dateFrom->diff($dateTo)->days;
			if($user_type != ''){
				if($user_type == 'Premium - One Month Free'){
					$user_type = 'Premium ( Monthly )';
				}else if($user_type == 'Free'){
					$user_type = 'Free';
				}else{
					$user_type = 'Premium ( '.$user_type.' )';
				}
				if(strtolower($user_type) != 'free' && strtotime($expirydate) < strtotime($currentDate)){
					$user_type = 'Free';
				}
				$date = strtotime($LastPaymentDate);
				$LastPaymentDate = date('d-m-Y',$date);
				$data = array("Plan"=>$user_type,"LastPaymentDate"=>$LastPaymentDate,"NextPaymentDate"=>$NextPaymentdate,'ORDER_ID'=>$ORDER_ID,"difference_date"=>$difference_date);
			}else{
				$data = array("Plan"=>$user_type,"LastPaymentDate"=>"","NextPaymentDate"=>"","message"=>"Invalid License Key");
			}
		}else{
			$data = array("Plan"=>"","LastPaymentDate"=>"","NextPaymentDate"=>"","message"=>"No Licence Key");
		}
		return $data;
	}
}
    
