<?php
/*+*******************************************************************************
* The content of this file is subject to the CRMTiger Pro license.
* ("License"); You may not use this file except in compliance with the License
* The Initial Developer of the Original Code is vTiger
* The Modified Code of the Original Code owned by https://crmtiger.com/
* Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
* All Rights Reserved.
 ***************************************************************************** */
class CTWhatsAppExt_LicenseEdit_View extends Settings_Vtiger_Index_View {

	function getPageTitle(Vtiger_Request $request) {
        $qualifiedModuleName = $request->getModule();
        return vtranslate('WhatsApp Chrome - Settings',$qualifiedModuleName).' > '.vtranslate('License Configuration',$qualifiedModuleName);
    }
    
    public function process(Vtiger_Request $request){
        $viewer = $this->getViewer($request);
        $qualifiedName = $request->getModule(false);
		$license_key =  $this->getLicense();
        $viewer->assign('LICENCE_KEY',$license_key);
        $viewer->assign('MODULE','CTWhatsAppExt');
        $viewer->view('LicenseEdit.tpl',$qualifiedName);
    }

    function getHeaderScripts(Vtiger_Request $request) {
		$headerScriptInstances = parent::getHeaderScripts($request);
		$moduleName = $request->getModule();

		$jsFileNames = array(
			"modules.Settings.$moduleName.resources.License",
			"modules.Vtiger.resources.SearchList",
		);

		$jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
		$headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
		return $headerScriptInstances;
    }

    function getLicense(){
		global $adb;
		$getLicenseQuery=$adb->pquery("SELECT * FROM ctwhatsappext_license_settings");
		$numOfLicense = $adb->num_rows($getLicenseQuery);
        if($numOfLicense > 0){
			$license_key = $adb->query_result($getLicenseQuery,0,'license_key');
		}else{
			$license_key = '';
		}
		return $license_key;
	}

}